/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db.repo;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCompany;
import com.axelor.apps.base.db.repo.ProductBaseRepository;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.StockConfigRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.apps.stock.service.app.AppStockService;
import com.axelor.db.mapper.Mapper;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ProductStockRepository
extends ProductBaseRepository {
    @Inject
    private StockMoveService stockMoveService;
    @Inject
    private StockLocationRepository stockLocationRepo;
    @Inject
    private AppStockService appStockService;
    @Inject
    private StockLocationLineService stockLocationLineService;

    public Product save(Product product) {
        WeightedAveragePriceService weightedAveragePriceService = (WeightedAveragePriceService)Beans.get(WeightedAveragePriceService.class);
        Set specificProductFieldSet = this.appBaseService.getAppBase().getCompanySpecificProductFieldsList();
        if (!specificProductFieldSet.isEmpty() && this.appBaseService.getAppBase().getEnableMultiCompany().booleanValue()) {
            ArrayList<Company> productCompanyList = new ArrayList<Company>();
            if (product.getProductCompanyList() != null) {
                for (ProductCompany productCompany : product.getProductCompanyList()) {
                    productCompanyList.add(productCompany.getCompany());
                }
            }
            Mapper mapper = Mapper.of(Product.class);
            List stockConfigList = ((StockConfigRepository)((Object)Beans.get(StockConfigRepository.class))).all().fetch();
            for (StockConfig stockConfig : stockConfigList) {
                if (stockConfig.getCompany() == null || productCompanyList.contains((Object)stockConfig.getCompany()) || stockConfig.getReceiptDefaultStockLocation() == null || stockConfig.getCompany().getArchived() != null && stockConfig.getCompany().getArchived().booleanValue()) continue;
                ProductCompany productCompany = new ProductCompany();
                for (MetaField specificField : specificProductFieldSet) {
                    mapper.set((Object)productCompany, specificField.getName(), mapper.get((Object)product, specificField.getName()));
                }
                productCompany.setAvgPrice(weightedAveragePriceService.computeAvgPriceForCompany(product, stockConfig.getCompany()));
                productCompany.setCompany(stockConfig.getCompany());
                productCompany.setProduct(product);
                product.addProductCompanyListItem(productCompany);
            }
        }
        return super.save(product);
    }

    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        this.setAvailableQty(json, context);
        if (!context.containsKey("fromStockWizard")) {
            return json;
        }
        try {
            Long productId = (Long)json.get("id");
            Long locationId = Long.parseLong(context.get("locationId").toString());
            LocalDate fromDate = LocalDate.parse(context.get("stockFromDate").toString());
            LocalDate toDate = LocalDate.parse(context.get("stockToDate").toString());
            List<Map<String, Object>> stock = this.stockMoveService.getStockPerDate(locationId, productId, fromDate, toDate);
            if (stock != null && !stock.isEmpty()) {
                LocalDate minDate = null;
                LocalDate maxDate = null;
                BigDecimal minQty = BigDecimal.ZERO;
                BigDecimal maxQty = BigDecimal.ZERO;
                for (Map<String, Object> dateStock : stock) {
                    LocalDate date = (LocalDate)dateStock.get("$date");
                    BigDecimal qty = (BigDecimal)dateStock.get("$qty");
                    if (minDate == null || qty.compareTo(minQty) < 0 || qty.compareTo(minQty) == 0 && date.isAfter(minDate)) {
                        minDate = date;
                        minQty = qty;
                    }
                    if (maxDate != null && qty.compareTo(maxQty) <= 0 && (qty.compareTo(maxQty) != 0 || !date.isBefore(maxDate))) continue;
                    maxDate = date;
                    maxQty = qty;
                }
                json.put("$stockMinDate", minDate);
                json.put("$stockMin", minQty);
                json.put("$stockMaxDate", maxDate);
                json.put("$stockMax", maxQty);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return json;
    }

    private void setAvailableQty(Map<String, Object> json, Map<String, Object> context) {
        try {
            Long productId = (Long)json.get("id");
            Product product = (Product)((Object)this.find(productId));
            if (context.get("_parent") != null) {
                Map _parent = (Map)context.get("_parent");
                StockLocation stockLocation = null;
                if (context.get("_model").toString().equals("com.axelor.apps.stock.db.StockMoveLine")) {
                    if (_parent.get("fromStockLocation") != null) {
                        stockLocation = (StockLocation)((Object)this.stockLocationRepo.find(Long.parseLong(((Map)_parent.get("fromStockLocation")).get("id").toString())));
                    }
                } else if (_parent.get("stockLocation") != null) {
                    stockLocation = (StockLocation)((Object)this.stockLocationRepo.find(Long.parseLong(((Map)_parent.get("stockLocation")).get("id").toString())));
                }
                if (stockLocation != null) {
                    BigDecimal availableQty = this.stockLocationLineService.getAvailableQty(stockLocation, product);
                    json.put("$availableQty", availableQty);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Product copy(Product product, boolean deep) {
        Product copy = super.copy(product, deep);
        copy.setAvgPrice(BigDecimal.ZERO);
        return copy;
    }
}

