/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db.repo;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import java.util.Map;
import javax.persistence.PersistenceException;

public class StockMoveManagementRepository
extends StockMoveRepository {
    public StockMove copy(StockMove entity, boolean deep) {
        StockMove copy = (StockMove)((Object)super.copy((Model)((Object)entity), deep));
        copy.setStatusSelect(1);
        copy.setStockMoveSeq(null);
        copy.setName(null);
        copy.setRealDate(null);
        copy.setPickingEditDate(null);
        copy.setPickingIsEdited(false);
        copy.setAvailabilityRequest(false);
        copy.setSupplierShipmentDate(null);
        copy.setSupplierShipmentRef(null);
        copy.setAvailabilityRequest(false);
        copy.setFullySpreadOverLogisticalFormsFlag(false);
        return copy;
    }

    public StockMove save(StockMove entity) {
        try {
            StockMove stockMove = (StockMove)((Object)super.save((Model)((Object)entity)));
            SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
            if (Strings.isNullOrEmpty((String)stockMove.getStockMoveSeq())) {
                stockMove.setStockMoveSeq(sequenceService.getDraftSequenceNumber((Model)((Object)stockMove)));
            }
            if (Strings.isNullOrEmpty((String)stockMove.getName()) || stockMove.getName().startsWith(stockMove.getStockMoveSeq())) {
                stockMove.setName(((StockMoveToolService)Beans.get(StockMoveToolService.class)).computeName(stockMove));
            }
            return stockMove;
        }
        catch (Exception e) {
            throw new PersistenceException((Throwable)e);
        }
    }

    public void remove(StockMove entity) {
        if (entity.getStatusSelect() == 2) {
            throw new PersistenceException(I18n.get((String)"Can't delete a planned stock move"));
        }
        if (entity.getStatusSelect() == 3) {
            throw new PersistenceException(I18n.get((String)"Can't delete a realized stock move"));
        }
        if (entity.getStockMoveOrigin() != null) {
            entity.getStockMoveOrigin().setBackorderId(null);
        }
        super.remove((Model)((Object)entity));
    }

    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        Long stockMoveId = (Long)json.get("id");
        StockMove stockMove = (StockMove)((Object)this.find(stockMoveId));
        if (stockMove.getStatusSelect() > 2 || stockMove.getStockMoveLineList() == null || stockMove.getFromStockLocation() != null && stockMove.getFromStockLocation().getTypeSelect() == 3) {
            return super.populate(json, context);
        }
        int available = 0;
        int availableForProduct = 0;
        int missing = 0;
        for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
            if (stockMoveLine != null && stockMoveLine.getProduct() != null && stockMoveLine.getProduct().getProductTypeSelect() != null && stockMoveLine.getProduct().getProductTypeSelect().equals("service")) continue;
            ((StockMoveLineService)Beans.get(StockMoveLineService.class)).updateAvailableQty(stockMoveLine, stockMove.getFromStockLocation());
            Product product = stockMoveLine.getProduct();
            if (stockMoveLine.getAvailableQty().compareTo(stockMoveLine.getRealQty()) >= 0 || product != null && !product.getStockManaged().booleanValue()) {
                ++available;
                continue;
            }
            if (stockMoveLine.getAvailableQtyForProduct().compareTo(stockMoveLine.getRealQty()) >= 0) {
                ++availableForProduct;
                continue;
            }
            if (stockMoveLine.getAvailableQty().compareTo(stockMoveLine.getRealQty()) >= 0 || stockMoveLine.getAvailableQtyForProduct().compareTo(stockMoveLine.getRealQty()) >= 0) continue;
            ++missing;
        }
        if ((available > 0 || availableForProduct > 0) && missing == 0) {
            json.put("availableStatusSelect", 1);
        } else if ((available > 0 || availableForProduct > 0) && missing > 0) {
            json.put("availableStatusSelect", 2);
        } else if (available == 0 && availableForProduct == 0 && missing > 0) {
            json.put("availableStatusSelect", 3);
        }
        return super.populate(json, context);
    }
}

