/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.db.repo;

import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.db.repo.TrackingNumberRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.Map;

public class TrackingNumberManagementRepository
extends TrackingNumberRepository {
    @Inject
    private StockLocationRepository stockLocationRepo;
    @Inject
    private StockLocationLineService stockLocationLineService;

    public Map<String, Object> populate(Map<String, Object> json, Map<String, Object> context) {
        try {
            StockLocation stockLocation;
            Map _parent;
            Long trackingNumberId = (Long)json.get("id");
            TrackingNumber trackingNumber = (TrackingNumber)((Object)this.find(trackingNumberId));
            if (trackingNumber.getProduct() != null && context.get("_parent") != null && (_parent = (Map)context.get("_parent")).get("fromStockLocation") != null && (stockLocation = (StockLocation)((Object)this.stockLocationRepo.find(Long.parseLong(((Map)_parent.get("fromStockLocation")).get("id").toString())))) != null) {
                BigDecimal availableQty = this.stockLocationLineService.getTrackingNumberAvailableQty(stockLocation, trackingNumber);
                json.put("$availableQty", availableQty);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return super.populate(json, context);
    }
}

