/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.ABCAnalysis;
import com.axelor.apps.base.db.ABCAnalysisLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ABCAnalysisClassRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisLineRepository;
import com.axelor.apps.base.db.repo.ABCAnalysisRepository;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ABCAnalysisServiceImpl;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.db.JPA;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;

public class ABCAnalysisServiceStockImpl
extends ABCAnalysisServiceImpl {
    protected StockLocationService stockLocationService;
    protected StockLocationLineRepository stockLocationLineRepository;
    private static final String STOCK_MANAGED_TRUE = " AND self.stockManaged = TRUE";

    @Inject
    public ABCAnalysisServiceStockImpl(ABCAnalysisLineRepository abcAnalysisLineRepository, UnitConversionService unitConversionService, ABCAnalysisRepository abcAnalysisRepository, ProductRepository productRepository, StockLocationService stockLocationService, StockLocationLineRepository stockLocationLineRepository, ABCAnalysisClassRepository abcAnalysisClassRepository, SequenceService sequenceService) {
        super(abcAnalysisLineRepository, unitConversionService, abcAnalysisRepository, productRepository, abcAnalysisClassRepository, sequenceService);
        this.stockLocationService = stockLocationService;
        this.stockLocationLineRepository = stockLocationLineRepository;
    }

    protected Optional<ABCAnalysisLine> createABCAnalysisLine(ABCAnalysis abcAnalysis, Product product) throws AxelorException {
        List stockLocationLineList;
        ABCAnalysisLine abcAnalysisLine = null;
        List<StockLocation> stockLocationList = this.stockLocationService.getAllLocationAndSubLocation(abcAnalysis.getStockLocation(), false);
        BigDecimal productQty = BigDecimal.ZERO;
        BigDecimal productWorth = BigDecimal.ZERO;
        int offset = 0;
        Query stockLocationLineQuery = this.stockLocationLineRepository.all().filter("self.stockLocation IN :stockLocationList AND self.product.id = :productId AND self.currentQty != 0 ").bind("stockLocationList", stockLocationList).bind("productId", (Object)product.getId());
        while (!(stockLocationLineList = stockLocationLineQuery.fetch(10, offset)).isEmpty()) {
            offset += stockLocationLineList.size();
            abcAnalysis = (ABCAnalysis)((Object)this.abcAnalysisRepository.find(abcAnalysis.getId()));
            if (abcAnalysisLine == null) {
                abcAnalysisLine = (ABCAnalysisLine)super.createABCAnalysisLine(abcAnalysis, product).get();
            }
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                BigDecimal convertedQty = this.unitConversionService.convert(stockLocationLine.getUnit(), product.getUnit(), stockLocationLine.getCurrentQty(), 5, product);
                productQty = productQty.add(convertedQty);
                productWorth = productWorth.add(stockLocationLine.getAvgPrice());
            }
            super.incTotalQty(productQty);
            super.incTotalWorth(productWorth);
            JPA.clear();
        }
        if (abcAnalysisLine != null) {
            this.setQtyWorth((ABCAnalysisLine)this.abcAnalysisLineRepository.find(abcAnalysisLine.getId()), productQty, productWorth);
        }
        return Optional.ofNullable(abcAnalysisLine);
    }

    protected String getProductCategoryQuery() {
        return super.getProductCategoryQuery() + STOCK_MANAGED_TRUE;
    }

    protected String getProductFamilyQuery() {
        return super.getProductFamilyQuery() + STOCK_MANAGED_TRUE;
    }
}

