/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.stock.db.Inventory;
import com.axelor.apps.stock.db.InventoryLine;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.inject.Beans;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class InventoryLineService {
    public InventoryLine createInventoryLine(Inventory inventory, Product product, BigDecimal currentQty, String rack, TrackingNumber trackingNumber) {
        InventoryLine inventoryLine = new InventoryLine();
        inventoryLine.setInventory(inventory);
        inventoryLine.setProduct(product);
        inventoryLine.setRack(rack);
        inventoryLine.setCurrentQty(currentQty);
        inventoryLine.setTrackingNumber(trackingNumber);
        this.compute(inventoryLine, inventory);
        return inventoryLine;
    }

    public InventoryLine updateInventoryLine(InventoryLine inventoryLine, Inventory inventory) {
        StockLocation stockLocation = inventory.getStockLocation();
        Product product = inventoryLine.getProduct();
        if (product != null) {
            StockLocationLine stockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getOrCreateStockLocationLine(stockLocation, product);
            if (stockLocationLine != null) {
                inventoryLine.setCurrentQty(stockLocationLine.getCurrentQty());
                inventoryLine.setRack(stockLocationLine.getRack());
                if (inventoryLine.getTrackingNumber() != null) {
                    inventoryLine.setCurrentQty(((StockLocationLineRepository)((Object)Beans.get(StockLocationLineRepository.class))).all().filter("self.product = :product and self.detailsStockLocation = :stockLocation and self.trackingNumber = :trackingNumber").bind("product", (Object)inventoryLine.getProduct()).bind("stockLocation", (Object)stockLocation).bind("trackingNumber", (Object)inventoryLine.getTrackingNumber()).fetchStream().map(it -> it.getCurrentQty()).reduce(BigDecimal.ZERO, (a, b) -> a.add((BigDecimal)b)));
                }
            } else {
                inventoryLine.setCurrentQty(null);
                inventoryLine.setRack(null);
            }
        }
        return inventoryLine;
    }

    public InventoryLine compute(InventoryLine inventoryLine, Inventory inventory) {
        StockLocation stockLocation = inventory.getStockLocation();
        Product product = inventoryLine.getProduct();
        if (product != null) {
            StockLocationLine stockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getStockLocationLine(stockLocation, product);
            inventoryLine.setUnit(product.getUnit());
            BigDecimal gap = inventoryLine.getRealQty() != null ? inventoryLine.getCurrentQty().subtract(inventoryLine.getRealQty()).setScale(2, RoundingMode.HALF_EVEN) : BigDecimal.ZERO;
            inventoryLine.setGap(gap);
            if (stockLocationLine != null) {
                inventoryLine.setGapValue(stockLocationLine.getAvgPrice().multiply(gap).setScale(2, RoundingMode.HALF_EVEN));
            }
        }
        return inventoryLine;
    }
}

