/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.exception.LogisticalFormError;
import com.axelor.apps.stock.service.LogisticalFormLineService;
import com.axelor.apps.stock.service.LogisticalFormService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.tool.StringTool;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.script.ScriptHelper;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class LogisticalFormLineServiceImpl
implements LogisticalFormLineService {
    private static final Pattern DIMENSIONS_PATTERN = Pattern.compile("\\s*\\d+(\\.\\d*)?\\s*[x\\*]\\s*\\d+(\\.\\d*)?\\s*[x\\*]\\s*\\d+(\\.\\d*)?\\s*");

    @Override
    public BigDecimal getUnspreadQty(LogisticalFormLine logisticalFormLine) {
        StockMoveLine stockMoveLine = logisticalFormLine.getStockMoveLine();
        return ((StockMoveLineService)Beans.get(StockMoveLineService.class)).computeSpreadableQtyOverLogisticalFormLines(stockMoveLine, logisticalFormLine.getLogisticalForm());
    }

    @Override
    public String getStockMoveLineDomain(LogisticalFormLine logisticalFormLine) {
        List<StockMoveLine> fullySpreadStockMoveLineList;
        Partner deliverToCustomerPartner;
        long partnerId = 0L;
        ArrayList<String> domainList = new ArrayList<String>();
        LogisticalForm logisticalForm = logisticalFormLine.getLogisticalForm();
        if (logisticalForm != null && (deliverToCustomerPartner = logisticalForm.getDeliverToCustomerPartner()) != null) {
            partnerId = deliverToCustomerPartner.getId();
        }
        domainList.add(String.format("self.stockMove.partner.id = %d", partnerId));
        domainList.add(String.format("self.stockMove.typeSelect = %d", 2));
        domainList.add(String.format("self.stockMove.statusSelect in (%d, %d)", 2, 3));
        domainList.add("self.realQty > 0");
        domainList.add("COALESCE(self.stockMove.fullySpreadOverLogisticalFormsFlag, FALSE) = FALSE");
        if (logisticalForm.getStockLocation() != null) {
            domainList.add(String.format("self.stockMove.fromStockLocation.id = %d", logisticalForm.getStockLocation().getId()));
        }
        if (!(fullySpreadStockMoveLineList = ((LogisticalFormService)Beans.get(LogisticalFormService.class)).getFullySpreadStockMoveLineList(logisticalForm)).isEmpty()) {
            String idListString = StringTool.getIdListString(fullySpreadStockMoveLineList);
            domainList.add(String.format("self.id NOT IN (%s)", idListString));
        }
        return domainList.stream().map(domain -> String.format("(%s)", domain)).collect(Collectors.joining(" AND "));
    }

    @Override
    public void validateDimensions(LogisticalFormLine logisticalFormLine) throws LogisticalFormError {
        String dimensions = logisticalFormLine.getDimensions();
        if (!Strings.isNullOrEmpty((String)dimensions) && !DIMENSIONS_PATTERN.matcher(dimensions).matches()) {
            throw new LogisticalFormError(logisticalFormLine, I18n.get((String)"Invalid dimensions on packing line No. %d"), logisticalFormLine.getSequence() + 1);
        }
    }

    @Override
    public BigDecimal evalVolume(LogisticalFormLine logisticalFormLine, ScriptHelper scriptHelper) throws LogisticalFormError {
        this.validateDimensions(logisticalFormLine);
        String script = logisticalFormLine.getDimensions();
        if (Strings.isNullOrEmpty((String)script)) {
            return BigDecimal.ZERO;
        }
        return (BigDecimal)scriptHelper.eval(String.format("new BigDecimal(%s)", script.replaceAll("x", "*")));
    }

    @Override
    public void initParcelPallet(LogisticalFormLine logisticalFormLine) {
        LogisticalFormService logisticalFormService = (LogisticalFormService)Beans.get(LogisticalFormService.class);
        logisticalFormLine.setParcelPalletNumber(logisticalFormService.getNextParcelPalletNumber(logisticalFormLine.getLogisticalForm(), logisticalFormLine.getTypeSelect()));
        logisticalFormLine.setSequence(logisticalFormService.getNextLineSequence(logisticalFormLine.getLogisticalForm()));
    }
}

