/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.StockCorrection;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.service.StockCorrectionService;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.config.StockConfigService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class StockCorrectionServiceImpl
implements StockCorrectionService {
    @Inject
    private StockConfigService stockConfigService;
    @Inject
    private ProductCompanyService productCompanyService;

    @Override
    public Map<String, Object> fillDefaultValues(StockLocationLine stockLocationLine) {
        HashMap<String, Object> stockCorrectionInformation = new HashMap<String, Object>();
        stockCorrectionInformation.put("stockLocation", (Object)(stockLocationLine.getStockLocation() != null ? stockLocationLine.getStockLocation() : stockLocationLine.getDetailsStockLocation()));
        stockCorrectionInformation.put("product", (Object)stockLocationLine.getProduct());
        stockCorrectionInformation.put("trackingNumber", (Object)stockLocationLine.getTrackingNumber());
        this.getDefaultQtys(stockLocationLine, stockCorrectionInformation);
        return stockCorrectionInformation;
    }

    @Override
    public Map<String, Object> fillDeafultQtys(StockCorrection stockCorrection) {
        HashMap<String, Object> stockCorrectionQtys = new HashMap<String, Object>();
        StockLocationLineService stockLocationLineService = (StockLocationLineService)Beans.get(StockLocationLineService.class);
        StockLocationLine stockLocationLine = stockCorrection.getTrackingNumber() == null ? stockLocationLineService.getStockLocationLine(stockCorrection.getStockLocation(), stockCorrection.getProduct()) : stockLocationLineService.getDetailLocationLine(stockCorrection.getStockLocation(), stockCorrection.getProduct(), stockCorrection.getTrackingNumber());
        if (stockLocationLine != null) {
            this.getDefaultQtys(stockLocationLine, stockCorrectionQtys);
        }
        return stockCorrectionQtys;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public boolean validate(StockCorrection stockCorrection) throws AxelorException {
        AppBaseService baseService = (AppBaseService)Beans.get(AppBaseService.class);
        StockMove stockMove = this.generateStockMove(stockCorrection);
        if (stockMove != null) {
            stockCorrection.setStatusSelect(2);
            stockCorrection.setValidationDateT(baseService.getTodayDateTime().toLocalDateTime());
            return true;
        }
        return false;
    }

    public StockMove generateStockMove(StockCorrection stockCorrection) throws AxelorException {
        StockLocation toStockLocation = stockCorrection.getStockLocation();
        Company company = toStockLocation.getCompany();
        StockLocation fromStockLocation = this.stockConfigService.getInventoryVirtualStockLocation(this.stockConfigService.getStockConfig(company));
        StockMoveService stockMoveService = (StockMoveService)Beans.get(StockMoveService.class);
        StockMoveLineService stockMoveLineService = (StockMoveLineService)Beans.get(StockMoveLineService.class);
        StockLocationLine stockLocationLine = null;
        StockLocationLineService stockLocationLineService = (StockLocationLineService)Beans.get(StockLocationLineService.class);
        stockLocationLine = stockCorrection.getTrackingNumber() == null ? stockLocationLineService.getStockLocationLine(stockCorrection.getStockLocation(), stockCorrection.getProduct()) : stockLocationLineService.getDetailLocationLine(stockCorrection.getStockLocation(), stockCorrection.getProduct(), stockCorrection.getTrackingNumber());
        BigDecimal realQty = stockCorrection.getRealQty();
        Product product = stockCorrection.getProduct();
        TrackingNumber trackingNumber = stockCorrection.getTrackingNumber();
        BigDecimal diff = realQty.subtract(stockLocationLine.getCurrentQty());
        StockMove stockMove = null;
        if (diff.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        stockMove = diff.compareTo(BigDecimal.ZERO) > 0 ? this.createStockMoveHeader(company, fromStockLocation, toStockLocation) : this.createStockMoveHeader(company, toStockLocation, fromStockLocation);
        stockMove.setOriginTypeSelect("com.axelor.apps.stock.db.StockCorrection");
        stockMove.setOriginId(stockCorrection.getId());
        stockMove.setStockCorrectionReason(stockCorrection.getStockCorrectionReason());
        BigDecimal productCostPrice = (BigDecimal)this.productCompanyService.get(product, "costPrice", company);
        StockMoveLine stockMoveLine = stockMoveLineService.createStockMoveLine(product, product.getName(), product.getDescription(), diff.abs(), productCostPrice, productCostPrice, product.getUnit(), stockMove, 0, false, BigDecimal.ZERO);
        if (stockMoveLine == null) {
            throw new AxelorException((Model)((Object)stockCorrection), 4, I18n.get((String)"Incorrect product for stock correction"));
        }
        if (trackingNumber != null && stockMoveLine.getTrackingNumber() == null) {
            stockMoveLine.setTrackingNumber(trackingNumber);
        }
        stockMoveService.plan(stockMove);
        stockMoveService.copyQtyToRealQty(stockMove);
        stockMoveService.realize(stockMove, false);
        return stockMove;
    }

    public StockMove createStockMoveHeader(Company company, StockLocation fromStockLocation, StockLocation toStockLocation) throws AxelorException {
        StockMove stockMove = ((StockMoveService)Beans.get(StockMoveService.class)).createStockMove(null, null, company, fromStockLocation, toStockLocation, null, null, null, 1);
        return stockMove;
    }

    @Override
    public void getDefaultQtys(StockLocationLine stockLocationLine, Map<String, Object> stockCorrectionQtys) {
        stockCorrectionQtys.put("realQty", stockLocationLine.getCurrentQty());
        stockCorrectionQtys.put("futureQty", stockLocationLine.getFutureQty());
    }
}

