/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.UnitConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.WapHistory;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.WapHistoryRepository;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.apps.tool.StringTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import com.google.inject.servlet.RequestScoped;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class StockLocationLineServiceImpl
implements StockLocationLineService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected StockLocationLineRepository stockLocationLineRepo;
    protected StockRulesService stockRulesService;
    protected StockMoveLineRepository stockMoveLineRepository;
    protected AppBaseService appBaseService;
    protected WapHistoryRepository wapHistoryRepo;
    protected static final String STOCK_MOVE_LINE_FILTER = "(self.stockMove.archived IS NULL OR self.archived IS FALSE) AND self.stockMove.statusSelect = :planned AND self.product.id = :productId ";

    @Inject
    public StockLocationLineServiceImpl(StockLocationLineRepository stockLocationLineRepo, StockRulesService stockRulesService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, WapHistoryRepository wapHistoryRepo) {
        this.stockLocationLineRepo = stockLocationLineRepo;
        this.stockRulesService = stockRulesService;
        this.stockMoveLineRepository = stockMoveLineRepository;
        this.appBaseService = appBaseService;
        this.wapHistoryRepo = wapHistoryRepo;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateLocation(StockLocation stockLocation, Product product, Unit stockMoveLineUnit, BigDecimal qty, boolean current, boolean future, boolean isIncrement, LocalDate lastFutureStockMoveDate, TrackingNumber trackingNumber) throws AxelorException {
        this.updateLocation(stockLocation, product, stockMoveLineUnit, qty, current, future, isIncrement, lastFutureStockMoveDate);
        if (trackingNumber != null) {
            this.updateDetailLocation(stockLocation, product, stockMoveLineUnit, qty, current, future, isIncrement, lastFutureStockMoveDate, trackingNumber);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateLocation(StockLocation stockLocation, Product product, Unit stockMoveLineUnit, BigDecimal qty, boolean current, boolean future, boolean isIncrement, LocalDate lastFutureStockMoveDate) throws AxelorException {
        StockLocationLine stockLocationLine = this.getOrCreateStockLocationLine(stockLocation, product);
        if (stockLocationLine == null) {
            return;
        }
        UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
        Unit stockLocationLineUnit = stockLocationLine.getUnit();
        if (stockLocationLineUnit != null && !stockLocationLineUnit.equals((Object)stockMoveLineUnit)) {
            qty = unitConversionService.convert(stockMoveLineUnit, stockLocationLineUnit, qty, qty.scale(), product);
        }
        LOG.debug("Mise \u00e0 jour du stock : Entrepot? {}, Produit? {}, Quantit\u00e9? {}, Actuel? {}, Futur? {}, Incr\u00e9ment? {}, Date? {} ", new Object[]{stockLocation.getName(), product.getCode(), qty, current, future, isIncrement, lastFutureStockMoveDate});
        if (!isIncrement) {
            this.minStockRules(product, qty, stockLocationLine, current, future);
        } else {
            this.maxStockRules(product, qty, stockLocationLine, current, future);
        }
        stockLocationLine = this.updateLocation(stockLocationLine, stockMoveLineUnit, product, qty, current, future, isIncrement, lastFutureStockMoveDate);
        this.checkStockMin(stockLocationLine, false);
        this.stockLocationLineRepo.save((Model)((Object)stockLocationLine));
    }

    @Override
    public void minStockRules(Product product, BigDecimal qty, StockLocationLine stockLocationLine, boolean current, boolean future) throws AxelorException {
        if (current) {
            this.stockRulesService.generateOrder(product, qty, stockLocationLine, 1);
        }
        if (future) {
            this.stockRulesService.generateOrder(product, qty, stockLocationLine, 2);
        }
    }

    public void maxStockRules(Product product, BigDecimal qty, StockLocationLine stockLocationLine, boolean current, boolean future) throws AxelorException {
        if (current) {
            this.checkStockMax(product, qty, stockLocationLine, 1, stockLocationLine.getCurrentQty());
        }
        if (future) {
            this.checkStockMax(product, qty, stockLocationLine, 2, stockLocationLine.getFutureQty());
        }
    }

    protected void checkStockMax(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type, BigDecimal baseQty) throws AxelorException {
        StockLocation stockLocation = stockLocationLine.getStockLocation();
        StockRules stockRules = this.stockRulesService.getStockRules(product, stockLocation, type, 2);
        if (stockRules == null || !stockRules.getUseMaxQty().booleanValue()) {
            return;
        }
        if (baseQty.add(qty).compareTo(stockRules.getMaxQty()) > 0) {
            throw new AxelorException((Model)((Object)stockLocationLine), 4, I18n.get((String)"Product's stocks %s (%s) exceeds maximum stock rules."), new Object[]{stockLocationLine.getProduct().getName(), stockLocationLine.getProduct().getCode()});
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateDetailLocation(StockLocation stockLocation, Product product, Unit stockMoveLineUnit, BigDecimal qty, boolean current, boolean future, boolean isIncrement, LocalDate lastFutureStockMoveDate, TrackingNumber trackingNumber) throws AxelorException {
        StockLocationLine detailLocationLine = this.getOrCreateDetailLocationLine(stockLocation, product, trackingNumber);
        if (detailLocationLine == null) {
            return;
        }
        UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
        Unit stockLocationLineUnit = detailLocationLine.getUnit();
        if (stockLocationLineUnit != null && !stockLocationLineUnit.equals((Object)stockMoveLineUnit)) {
            qty = unitConversionService.convert(stockMoveLineUnit, stockLocationLineUnit, qty, qty.scale(), product);
        }
        LOG.debug("Mise \u00e0 jour du detail du stock : Entrepot? {}, Produit? {}, Quantit\u00e9? {}, Actuel? {}, Futur? {}, Incr\u00e9ment? {}, Date? {}, Num de suivi? {} ", new Object[]{stockLocation.getName(), product.getCode(), qty, current, future, isIncrement, lastFutureStockMoveDate, trackingNumber});
        detailLocationLine = this.updateLocation(detailLocationLine, stockMoveLineUnit, product, qty, current, future, isIncrement, lastFutureStockMoveDate);
        this.checkStockMin(detailLocationLine, true);
        this.stockLocationLineRepo.save((Model)((Object)detailLocationLine));
    }

    @Override
    public void checkStockMin(StockLocationLine stockLocationLine, boolean isDetailLocationLine) throws AxelorException {
        if (!isDetailLocationLine && stockLocationLine.getCurrentQty().compareTo(BigDecimal.ZERO) < 0 && stockLocationLine.getStockLocation().getTypeSelect() != 3) {
            throw new AxelorException((Model)((Object)stockLocationLine), 4, I18n.get((String)"Product's stocks %s (%s) are not in sufficient quantity to realize the delivery"), new Object[]{stockLocationLine.getProduct().getName(), stockLocationLine.getProduct().getCode()});
        }
        if (isDetailLocationLine && stockLocationLine.getCurrentQty().compareTo(BigDecimal.ZERO) < 0 && (stockLocationLine.getStockLocation() != null && stockLocationLine.getStockLocation().getTypeSelect() != 3 || stockLocationLine.getDetailsStockLocation() != null && stockLocationLine.getDetailsStockLocation().getTypeSelect() != 3)) {
            String trackingNumber = "";
            if (stockLocationLine.getTrackingNumber() != null) {
                trackingNumber = stockLocationLine.getTrackingNumber().getTrackingNumberSeq();
            }
            throw new AxelorException((Model)((Object)stockLocationLine), 4, I18n.get((String)"Product's stocks %s (%s), tracking number %s are not in sufficient quantity to realize the delivery"), new Object[]{stockLocationLine.getProduct().getName(), stockLocationLine.getProduct().getCode(), trackingNumber});
        }
    }

    @Override
    public void checkIfEnoughStock(StockLocation stockLocation, Product product, BigDecimal qty) throws AxelorException {
        if (!product.getStockManaged().booleanValue()) {
            return;
        }
        StockLocationLine stockLocationLine = this.getStockLocationLine(stockLocation, product);
        if (stockLocationLine != null && stockLocationLine.getCurrentQty().compareTo(qty) < 0) {
            throw new AxelorException((Model)((Object)stockLocationLine), 4, I18n.get((String)"Product's stocks %s (%s) are not in sufficient quantity to realize the delivery"), new Object[]{stockLocationLine.getProduct().getName(), stockLocationLine.getProduct().getCode()});
        }
    }

    @Override
    public StockLocationLine updateLocation(StockLocationLine stockLocationLine, Unit stockMoveLineUnit, Product product, BigDecimal qty, boolean current, boolean future, boolean isIncrement, LocalDate lastFutureStockMoveDate) throws AxelorException {
        if (current) {
            if (isIncrement) {
                stockLocationLine.setCurrentQty(stockLocationLine.getCurrentQty().add(qty));
            } else {
                stockLocationLine.setCurrentQty(stockLocationLine.getCurrentQty().subtract(qty));
            }
        }
        if (future) {
            stockLocationLine.setFutureQty(this.computeFutureQty(stockLocationLine));
            stockLocationLine.setLastFutureStockMoveDate(lastFutureStockMoveDate);
        }
        return stockLocationLine;
    }

    @Override
    public StockLocationLine getOrCreateStockLocationLine(StockLocation stockLocation, Product product) {
        if (!product.getStockManaged().booleanValue()) {
            return null;
        }
        StockLocationLine stockLocationLine = this.getStockLocationLine(stockLocation, product);
        if (stockLocationLine == null) {
            stockLocationLine = this.createLocationLine(stockLocation, product);
        }
        LOG.debug("R\u00e9cup\u00e9ration ligne de stock: Entrepot? {}, Produit? {}, Qt\u00e9 actuelle? {}, Qt\u00e9 future? {}, Date? {} ", new Object[]{stockLocationLine.getStockLocation().getName(), product.getCode(), stockLocationLine.getCurrentQty(), stockLocationLine.getFutureQty(), stockLocationLine.getLastFutureStockMoveDate()});
        return stockLocationLine;
    }

    @Override
    public StockLocationLine getOrCreateDetailLocationLine(StockLocation detailLocation, Product product, TrackingNumber trackingNumber) {
        StockLocationLine detailLocationLine = this.getDetailLocationLine(detailLocation, product, trackingNumber);
        if (detailLocationLine == null) {
            detailLocationLine = this.createDetailLocationLine(detailLocation, product, trackingNumber);
        }
        LOG.debug("R\u00e9cup\u00e9ration ligne de d\u00e9tail de stock: Entrepot? {}, Produit? {}, Qt\u00e9 actuelle? {}, Qt\u00e9 future? {}, Date? {}, Variante? {}, Num de suivi? {} ", new Object[]{detailLocationLine.getDetailsStockLocation().getName(), product.getCode(), detailLocationLine.getCurrentQty(), detailLocationLine.getFutureQty(), detailLocationLine.getLastFutureStockMoveDate(), detailLocationLine.getTrackingNumber()});
        return detailLocationLine;
    }

    @Override
    public StockLocationLine getStockLocationLine(StockLocation stockLocation, Product product) {
        if (product == null || !product.getStockManaged().booleanValue()) {
            return null;
        }
        return (StockLocationLine)((Object)this.stockLocationLineRepo.all().filter("self.stockLocation.id = :_stockLocationId AND self.product.id = :_productId").bind("_stockLocationId", (Object)stockLocation.getId()).bind("_productId", (Object)product.getId()).fetchOne());
    }

    @Override
    public List<StockLocationLine> getStockLocationLines(Product product) {
        if (product != null && !product.getStockManaged().booleanValue()) {
            return null;
        }
        return this.stockLocationLineRepo.all().filter("self.product.id = :_productId").bind("_productId", (Object)product.getId()).fetch();
    }

    @Override
    public StockLocationLine getDetailLocationLine(StockLocation stockLocation, Product product, TrackingNumber trackingNumber) {
        return (StockLocationLine)((Object)this.stockLocationLineRepo.all().filter("self.detailsStockLocation.id = :_stockLocationId AND self.product.id = :_productId AND self.trackingNumber.id = :_trackingNumberId").bind("_stockLocationId", (Object)stockLocation.getId()).bind("_productId", (Object)product.getId()).bind("_trackingNumberId", (Object)trackingNumber.getId()).fetchOne());
    }

    @Override
    public StockLocationLine createLocationLine(StockLocation stockLocation, Product product) {
        LOG.debug("Cr\u00e9ation d'une ligne de stock : Entrepot? {}, Produit? {} ", (Object)stockLocation.getName(), (Object)product.getCode());
        StockLocationLine stockLocationLine = new StockLocationLine();
        stockLocationLine.setStockLocation(stockLocation);
        stockLocation.addStockLocationLineListItem(stockLocationLine);
        stockLocationLine.setProduct(product);
        stockLocationLine.setUnit(product.getUnit());
        stockLocationLine.setCurrentQty(BigDecimal.ZERO);
        stockLocationLine.setFutureQty(BigDecimal.ZERO);
        return stockLocationLine;
    }

    @Override
    public StockLocationLine createDetailLocationLine(StockLocation stockLocation, Product product, TrackingNumber trackingNumber) {
        LOG.debug("Cr\u00e9ation d'une ligne de d\u00e9tail de stock : Entrepot? {}, Produit? {}, Num de suivi? {} ", new Object[]{stockLocation.getName(), product.getCode(), trackingNumber.getTrackingNumberSeq()});
        StockLocationLine detailLocationLine = new StockLocationLine();
        detailLocationLine.setDetailsStockLocation(stockLocation);
        stockLocation.addDetailsStockLocationLineListItem(detailLocationLine);
        detailLocationLine.setProduct(product);
        detailLocationLine.setUnit(product.getUnit());
        detailLocationLine.setCurrentQty(BigDecimal.ZERO);
        detailLocationLine.setFutureQty(BigDecimal.ZERO);
        detailLocationLine.setTrackingNumber(trackingNumber);
        return detailLocationLine;
    }

    @Override
    public BigDecimal getAvailableQty(StockLocation stockLocation, Product product) {
        StockLocationLine stockLocationLine = this.getStockLocationLine(stockLocation, product);
        BigDecimal availableQty = BigDecimal.ZERO;
        if (stockLocationLine != null) {
            availableQty = stockLocationLine.getCurrentQty();
        }
        return availableQty;
    }

    @Override
    public BigDecimal getTrackingNumberAvailableQty(StockLocation stockLocation, TrackingNumber trackingNumber) {
        StockLocationLine detailStockLocationLine = ((StockLocationLineService)Beans.get(StockLocationLineService.class)).getDetailLocationLine(stockLocation, trackingNumber.getProduct(), trackingNumber);
        BigDecimal availableQty = BigDecimal.ZERO;
        if (detailStockLocationLine != null) {
            availableQty = detailStockLocationLine.getCurrentQty();
        }
        return availableQty;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void updateStockLocationFromProduct(StockLocationLine stockLocationLine, Product product) throws AxelorException {
        stockLocationLine = this.updateLocationFromProduct(stockLocationLine, product);
        this.stockLocationLineRepo.save((Model)((Object)stockLocationLine));
    }

    @Override
    public StockLocationLine updateLocationFromProduct(StockLocationLine stockLocationLine, Product product) throws AxelorException {
        Unit productUnit = product.getUnit();
        Unit stockLocationUnit = stockLocationLine.getUnit();
        if (productUnit != null && !productUnit.equals((Object)stockLocationUnit)) {
            AppBaseService appBaseService = (AppBaseService)Beans.get(AppBaseService.class);
            int scale = appBaseService.getNbDecimalDigitForUnitPrice();
            int qtyScale = appBaseService.getNbDecimalDigitForQty();
            BigDecimal oldQty = stockLocationLine.getCurrentQty();
            BigDecimal oldAvgPrice = stockLocationLine.getAvgPrice();
            UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
            BigDecimal currentQty = unitConversionService.convert(stockLocationUnit, productUnit, stockLocationLine.getCurrentQty(), stockLocationLine.getCurrentQty().scale(), product);
            stockLocationLine.setCurrentQty(currentQty);
            stockLocationLine.setUnit(product.getUnit());
            stockLocationLine.setFutureQty(this.computeFutureQty(stockLocationLine));
            BigDecimal avgQty = BigDecimal.ZERO;
            if (currentQty.compareTo(BigDecimal.ZERO) != 0) {
                avgQty = oldQty.divide(currentQty, qtyScale, RoundingMode.HALF_UP);
            }
            BigDecimal newAvgPrice = oldAvgPrice.multiply(avgQty);
            this.updateWap(stockLocationLine, newAvgPrice.setScale(scale, RoundingMode.HALF_UP));
        }
        return stockLocationLine;
    }

    @Override
    public BigDecimal computeFutureQty(StockLocationLine stockLocationLine) throws AxelorException {
        UnitConversionService unitConversionService = (UnitConversionService)Beans.get(UnitConversionService.class);
        Product product = stockLocationLine.getProduct();
        BigDecimal futureQty = stockLocationLine.getCurrentQty();
        List<StockMoveLine> incomingStockMoveLineList = this.findIncomingPlannedStockMoveLines(stockLocationLine);
        List<StockMoveLine> outgoingStockMoveLineList = this.findOutgoingPlannedStockMoveLines(stockLocationLine);
        for (StockMoveLine incomingStockMoveLine : incomingStockMoveLineList) {
            BigDecimal qtyToAdd = unitConversionService.convert(incomingStockMoveLine.getUnit(), stockLocationLine.getUnit(), incomingStockMoveLine.getRealQty(), incomingStockMoveLine.getRealQty().scale(), product);
            futureQty = futureQty.add(qtyToAdd);
        }
        for (StockMoveLine outgoingStockMoveLine : outgoingStockMoveLineList) {
            BigDecimal qtyToSubtract = unitConversionService.convert(outgoingStockMoveLine.getUnit(), stockLocationLine.getUnit(), outgoingStockMoveLine.getRealQty(), outgoingStockMoveLine.getRealQty().scale(), product);
            futureQty = futureQty.subtract(qtyToSubtract);
        }
        return futureQty;
    }

    protected List<StockMoveLine> findIncomingPlannedStockMoveLines(StockLocationLine stockLocationLine) {
        boolean isDetailsStockLocationLine = stockLocationLine.getDetailsStockLocation() != null;
        String incomingStockMoveLineFilter = "(self.stockMove.archived IS NULL OR self.archived IS FALSE) AND self.stockMove.statusSelect = :planned AND self.product.id = :productId AND self.stockMove.toStockLocation.id = :stockLocationId";
        if (isDetailsStockLocationLine) {
            incomingStockMoveLineFilter = incomingStockMoveLineFilter + " AND self.trackingNumber.id = :trackingNumberId";
        }
        Query stockMoveLineQuery = this.stockMoveLineRepository.all().filter(incomingStockMoveLineFilter).bind("planned", (Object)2).bind("productId", (Object)stockLocationLine.getProduct().getId());
        if (isDetailsStockLocationLine) {
            stockMoveLineQuery.bind("stockLocationId", (Object)stockLocationLine.getDetailsStockLocation().getId()).bind("trackingNumberId", (Object)stockLocationLine.getTrackingNumber().getId());
        } else {
            stockMoveLineQuery.bind("stockLocationId", (Object)stockLocationLine.getStockLocation().getId());
        }
        return stockMoveLineQuery.fetch();
    }

    protected List<StockMoveLine> findOutgoingPlannedStockMoveLines(StockLocationLine stockLocationLine) {
        boolean isDetailsStockLocationLine = stockLocationLine.getDetailsStockLocation() != null;
        String outgoingStockMoveLineFilter = "(self.stockMove.archived IS NULL OR self.archived IS FALSE) AND self.stockMove.statusSelect = :planned AND self.product.id = :productId AND self.stockMove.fromStockLocation.id = :stockLocationId";
        if (isDetailsStockLocationLine) {
            outgoingStockMoveLineFilter = outgoingStockMoveLineFilter + " AND self.trackingNumber.id = :trackingNumberId";
        }
        Query stockMoveLineQuery = this.stockMoveLineRepository.all().filter(outgoingStockMoveLineFilter).bind("planned", (Object)2).bind("productId", (Object)stockLocationLine.getProduct().getId());
        if (isDetailsStockLocationLine) {
            stockMoveLineQuery.bind("stockLocationId", (Object)stockLocationLine.getDetailsStockLocation().getId()).bind("trackingNumberId", (Object)stockLocationLine.getTrackingNumber().getId());
        } else {
            stockMoveLineQuery.bind("stockLocationId", (Object)stockLocationLine.getStockLocation().getId());
        }
        return stockMoveLineQuery.fetch();
    }

    @Override
    public String getStockLocationLineListForAProduct(Long productId, Long companyId, Long stockLocationId) {
        String query = "self.product.id = " + productId + " AND self.stockLocation.typeSelect != " + 3;
        if (companyId != 0L) {
            query = query + " AND self.stockLocation.company.id = " + companyId;
            if (stockLocationId != 0L) {
                StockLocation stockLocation = (StockLocation)((Object)((StockLocationRepository)((Object)Beans.get(StockLocationRepository.class))).find(stockLocationId));
                List<StockLocation> stockLocationList = ((StockLocationService)Beans.get(StockLocationService.class)).getAllLocationAndSubLocation(stockLocation, false);
                if (!stockLocationList.isEmpty() && stockLocation.getCompany().getId().equals(companyId)) {
                    query = query + " AND self.stockLocation.id IN (" + StringTool.getIdListString(stockLocationList) + ") ";
                }
            }
        }
        return query;
    }

    @Override
    public String getAvailableStockForAProduct(Long productId, Long companyId, Long stockLocationId) {
        String query = this.getStockLocationLineListForAProduct(productId, companyId, stockLocationId);
        query = query + " AND (self.currentQty != 0 OR self.futureQty != 0)  AND (self.stockLocation.isNotInCalculStock = false OR self.stockLocation.isNotInCalculStock IS NULL)";
        return query;
    }

    @Override
    public String getRequestedReservedQtyForAProduct(Long productId, Long companyId, Long stockLocationId) {
        String query = this.getStockLocationLineListForAProduct(productId, companyId, stockLocationId);
        query = query + " AND self.requestedReservedQty > 0";
        return query;
    }

    @Override
    public void updateWap(StockLocationLine stockLocationLine, BigDecimal wap) {
        this.updateWap(stockLocationLine, wap, null);
    }

    @Override
    public void updateWap(StockLocationLine stockLocationLine, BigDecimal wap, StockMoveLine stockMoveLine) {
        stockLocationLine.setAvgPrice(wap);
        this.wapHistoryRepo.save((Model)((Object)new WapHistory(stockLocationLine, this.appBaseService.getTodayDate(stockLocationLine.getStockLocation() != null ? stockLocationLine.getStockLocation().getCompany() : (Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)), wap, stockLocationLine.getCurrentQty(), stockLocationLine.getUnit(), stockMoveLine)));
    }
}

