/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.PartnerStockSettings;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.PartnerStockSettingsRepository;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.util.List;

public class StockLocationSaveService {
    @Transactional
    public void removeForbiddenDefaultStockLocation(StockLocation defaultStockLocation) {
        Partner currentPartner = defaultStockLocation.getPartner();
        Company currentCompany = defaultStockLocation.getCompany();
        Long partnerId = currentPartner != null ? currentPartner.getId() : 0L;
        Long companyId = currentCompany != null ? currentCompany.getId() : 0L;
        PartnerStockSettingsRepository partnerStockSettingsRepo = (PartnerStockSettingsRepository)((Object)Beans.get(PartnerStockSettingsRepository.class));
        List partnerStockSettingsToRemove = partnerStockSettingsRepo.all().filter("(self.partner.id != :partnerId OR self.company.id != :companyId) AND (self.defaultStockLocation.id = :stockLocationId)").bind("partnerId", (Object)partnerId).bind("companyId", (Object)companyId).bind("stockLocationId", (Object)defaultStockLocation.getId()).fetch();
        for (PartnerStockSettings partnerStockSettings : partnerStockSettingsToRemove) {
            Partner partnerToClean = partnerStockSettings.getPartner();
            partnerToClean.removePartnerStockSettingsListItem(partnerStockSettings);
        }
    }
}

