/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.TrackingNumber;
import com.axelor.apps.stock.db.TrackingNumberConfiguration;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;

public interface StockMoveLineService {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_SALES = 1;
    public static final int TYPE_PURCHASES = 2;
    public static final int TYPE_OUT_PRODUCTIONS = 3;
    public static final int TYPE_IN_PRODUCTIONS = 4;
    public static final int TYPE_WASTE_PRODUCTIONS = 5;

    public StockMoveLine createStockMoveLine(Product var1, String var2, String var3, BigDecimal var4, BigDecimal var5, BigDecimal var6, Unit var7, StockMove var8, int var9, boolean var10, BigDecimal var11) throws AxelorException;

    public void generateTrackingNumber(StockMoveLine var1, TrackingNumberConfiguration var2, Product var3, BigDecimal var4) throws AxelorException;

    public StockMoveLine createStockMoveLine(Product var1, String var2, String var3, BigDecimal var4, BigDecimal var5, BigDecimal var6, BigDecimal var7, BigDecimal var8, Unit var9, StockMove var10, TrackingNumber var11) throws AxelorException;

    public StockMoveLine assignOrGenerateTrackingNumber(StockMoveLine var1, StockMove var2, Product var3, TrackingNumberConfiguration var4, int var5) throws AxelorException;

    public void checkTrackingNumber(StockMove var1) throws AxelorException;

    public void assignTrackingNumber(StockMoveLine var1, Product var2, StockLocation var3) throws AxelorException;

    public List<? extends StockLocationLine> getStockLocationLines(Product var1, StockLocation var2) throws AxelorException;

    public StockMoveLine splitStockMoveLine(StockMoveLine var1, BigDecimal var2, TrackingNumber var3) throws AxelorException;

    public void updateLocations(StockLocation var1, StockLocation var2, int var3, int var4, List<StockMoveLine> var5, LocalDate var6, boolean var7) throws AxelorException;

    public void updateLocations(StockMoveLine var1, StockLocation var2, StockLocation var3, Product var4, BigDecimal var5, int var6, int var7, LocalDate var8, TrackingNumber var9) throws AxelorException;

    public void updateAveragePriceLocationLine(StockLocation var1, StockMoveLine var2, int var3, int var4) throws AxelorException;

    public void checkConformitySelection(StockMoveLine var1, StockMove var2) throws AxelorException;

    public void checkConformitySelection(StockMove var1) throws AxelorException;

    public void checkExpirationDates(StockMove var1) throws AxelorException;

    public Unit getStockUnit(StockMoveLine var1);

    public StockMoveLine compute(StockMoveLine var1, StockMove var2) throws AxelorException;

    public void storeCustomsCodes(List<StockMoveLine> var1);

    public boolean computeFullySpreadOverLogisticalFormLinesFlag(StockMoveLine var1);

    public BigDecimal computeSpreadableQtyOverLogisticalFormLines(StockMoveLine var1);

    public BigDecimal computeSpreadableQtyOverLogisticalFormLines(StockMoveLine var1, LogisticalForm var2);

    public void setProductInfo(StockMove var1, StockMoveLine var2, Company var3) throws AxelorException;

    public boolean checkMassesRequired(StockMove var1, StockMoveLine var2);

    @Transactional
    public void splitStockMoveLineByTrackingNumber(StockMoveLine var1, List<LinkedHashMap<String, Object>> var2);

    public void updateAvailableQty(StockMoveLine var1, StockLocation var2);

    public String createDomainForProduct(StockMoveLine var1, StockMove var2);

    public void setAvailableStatus(StockMoveLine var1);

    public List<TrackingNumber> getAvailableTrackingNumbers(StockMoveLine var1, StockMove var2);

    public void fillRealizeWapPrice(StockMoveLine var1);
}

