/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.CancelReason;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.stock.db.FreightCarrierMode;
import com.axelor.apps.stock.db.Incoterm;
import com.axelor.apps.stock.db.ShipmentMode;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.exception.AxelorException;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public interface StockMoveService {
    public StockMove createStockMove(Address var1, Address var2, Company var3, Partner var4, StockLocation var5, StockLocation var6, LocalDate var7, LocalDate var8, String var9, ShipmentMode var10, FreightCarrierMode var11, Partner var12, Partner var13, Incoterm var14, int var15) throws AxelorException;

    public StockMove createStockMove(Address var1, Address var2, Company var3, StockLocation var4, StockLocation var5, LocalDate var6, LocalDate var7, String var8, int var9) throws AxelorException;

    public void validate(StockMove var1) throws AxelorException;

    public void goBackToDraft(StockMove var1) throws AxelorException;

    public void plan(StockMove var1) throws AxelorException;

    public String realize(StockMove var1) throws AxelorException;

    public String realize(StockMove var1, boolean var2) throws AxelorException;

    public boolean mustBeSplit(List<StockMoveLine> var1);

    public Optional<StockMove> copyAndSplitStockMove(StockMove var1) throws AxelorException;

    public Optional<StockMove> copyAndSplitStockMove(StockMove var1, List<StockMoveLine> var2) throws AxelorException;

    public Optional<StockMove> copyAndSplitStockMoveReverse(StockMove var1, boolean var2) throws AxelorException;

    public Optional<StockMove> copyAndSplitStockMoveReverse(StockMove var1, List<StockMoveLine> var2, boolean var3) throws AxelorException;

    public void cancel(StockMove var1) throws AxelorException;

    public void cancel(StockMove var1, CancelReason var2) throws AxelorException;

    @Transactional
    public boolean splitStockMoveLines(StockMove var1, List<StockMoveLine> var2, BigDecimal var3);

    @Transactional
    public void copyQtyToRealQty(StockMove var1);

    @Transactional(rollbackOn={Exception.class})
    public Optional<StockMove> generateReversion(StockMove var1) throws AxelorException;

    public StockMove splitInto2(StockMove var1, List<StockMoveLine> var2) throws AxelorException;

    public List<Map<String, Object>> getStockPerDate(Long var1, Long var2, LocalDate var3, LocalDate var4);

    public List<StockMoveLine> changeConformityStockMove(StockMove var1);

    public Integer changeConformityStockMoveLine(StockMove var1);

    public Map<String, Object> viewDirection(StockMove var1) throws AxelorException;

    public String printStockMove(StockMove var1, List<Integer> var2, String var3) throws AxelorException;

    public void updateFullySpreadOverLogisticalFormsFlag(StockMove var1);

    public void setAvailableStatus(StockMove var1);

    public void checkExpirationDates(StockMove var1) throws AxelorException;

    public void setPickingStockMoveEditDate(StockMove var1, String var2);

    public void setPickingStockMovesEditDate(List<Long> var1, String var2);

    public void updateStocks(StockMove var1) throws AxelorException;

    public void updateProductNetMass(StockMove var1) throws AxelorException;
}

