/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.db.repo.StockMoveLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.PartnerProductQualityRatingService;
import com.axelor.apps.stock.service.StockMoveLineService;
import com.axelor.apps.stock.service.StockMoveToolService;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StockMoveToolServiceImpl
implements StockMoveToolService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected StockMoveLineService stockMoveLineService;
    protected AppBaseService appBaseService;
    protected StockMoveRepository stockMoveRepo;
    protected PartnerProductQualityRatingService partnerProductQualityRatingService;
    private SequenceService sequenceService;
    private StockMoveLineRepository stockMoveLineRepo;

    @Inject
    public StockMoveToolServiceImpl(StockMoveLineService stockMoveLineService, SequenceService sequenceService, StockMoveLineRepository stockMoveLineRepository, AppBaseService appBaseService, StockMoveRepository stockMoveRepository, PartnerProductQualityRatingService partnerProductQualityRatingService) {
        this.stockMoveLineService = stockMoveLineService;
        this.sequenceService = sequenceService;
        this.stockMoveLineRepo = stockMoveLineRepository;
        this.appBaseService = appBaseService;
        this.stockMoveRepo = stockMoveRepository;
        this.partnerProductQualityRatingService = partnerProductQualityRatingService;
    }

    @Override
    public BigDecimal compute(StockMove stockMove) {
        BigDecimal exTaxTotal = BigDecimal.ZERO;
        if (stockMove.getStockMoveLineList() != null && !stockMove.getStockMoveLineList().isEmpty()) {
            for (StockMoveLine stockMoveLine : stockMove.getStockMoveLineList()) {
                exTaxTotal = exTaxTotal.add(stockMoveLine.getRealQty().multiply(stockMoveLine.getUnitPriceUntaxed()));
            }
        }
        return exTaxTotal.setScale(2, RoundingMode.HALF_UP);
    }

    @Override
    public String getSequenceStockMove(int stockMoveType, Company company) throws AxelorException {
        String ref = "";
        switch (stockMoveType) {
            case 1: {
                ref = this.sequenceService.getSequenceNumber("intStockMove", company);
                if (ref != null) break;
                throw new AxelorException(4, I18n.get((String)"There's no configured sequence for stock's intern moves for the company %s"), new Object[]{company.getName()});
            }
            case 3: {
                ref = this.sequenceService.getSequenceNumber("inStockMove", company);
                if (ref != null) break;
                throw new AxelorException(4, I18n.get((String)"There's no configured sequence for stock's receptions for the company %s"), new Object[]{company.getName()});
            }
            case 2: {
                ref = this.sequenceService.getSequenceNumber("outStockMove", company);
                if (ref != null) break;
                throw new AxelorException(4, I18n.get((String)"There's no configured sequence for stock's delivery for the company %s"), new Object[]{company.getName()});
            }
            default: {
                throw new AxelorException(4, I18n.get((String)"Stock's movement's type undefined"), new Object[]{company.getName()});
            }
        }
        return ref;
    }

    @Override
    public boolean getDefaultISPM(Partner clientPartner, Address toAddress) {
        if (clientPartner != null && clientPartner.getIsIspmRequired().booleanValue()) {
            return true;
        }
        return toAddress != null && toAddress.getAddressL7Country() != null && toAddress.getAddressL7Country().getIsIspmRequired() != false;
    }

    @Override
    public int getStockMoveType(StockLocation fromStockLocation, StockLocation toStockLocation) {
        if (fromStockLocation.getTypeSelect() == 1 && toStockLocation.getTypeSelect() == 1) {
            return 1;
        }
        if (fromStockLocation.getTypeSelect() != 1 && toStockLocation.getTypeSelect() == 1) {
            return 3;
        }
        if (fromStockLocation.getTypeSelect() == 1 && toStockLocation.getTypeSelect() != 1) {
            return 2;
        }
        return 0;
    }

    @Override
    public Address getFromAddress(StockMove stockMove) {
        Address fromAddress = stockMove.getFromAddress();
        if (fromAddress == null && stockMove.getFromStockLocation() != null) {
            fromAddress = stockMove.getFromStockLocation().getAddress();
        }
        return fromAddress;
    }

    @Override
    public Address getToAddress(StockMove stockMove) {
        Address toAddress = stockMove.getToAddress();
        if (toAddress == null && stockMove.getToStockLocation() != null) {
            toAddress = stockMove.getToStockLocation().getAddress();
        }
        return toAddress;
    }

    @Override
    public void computeAddressStr(StockMove stockMove) {
        AddressService addressService = (AddressService)Beans.get(AddressService.class);
        stockMove.setFromAddressStr(addressService.computeAddressStr(stockMove.getFromAddress()));
        stockMove.setToAddressStr(addressService.computeAddressStr(stockMove.getToAddress()));
    }

    @Override
    public String computeName(StockMove stockMove) {
        return this.computeName(stockMove, null);
    }

    @Override
    public String computeName(StockMove stockMove, String name) {
        Objects.requireNonNull(stockMove);
        StringBuilder nameBuilder = new StringBuilder();
        if (Strings.isNullOrEmpty((String)name)) {
            if (!Strings.isNullOrEmpty((String)stockMove.getStockMoveSeq())) {
                nameBuilder.append(stockMove.getStockMoveSeq());
            }
        } else {
            nameBuilder.append(name);
        }
        if (stockMove.getPartner() != null && !Strings.isNullOrEmpty((String)stockMove.getPartner().getFullName())) {
            if (nameBuilder.length() > 0) {
                nameBuilder.append(" - ");
            }
            nameBuilder.append(stockMove.getPartner().getFullName());
        }
        return nameBuilder.toString();
    }

    @Override
    public Address getPartnerAddress(StockMove stockMove) throws AxelorException {
        Address address;
        if (stockMove.getTypeSelect() == 2) {
            address = this.getToAddress(stockMove);
        } else if (stockMove.getTypeSelect() == 3) {
            address = this.getFromAddress(stockMove);
        } else {
            throw new AxelorException((Model)((Object)stockMove), 5, I18n.get((String)"Bad stock move type"));
        }
        if (address.getAddressL7Country() == null) {
            throw new AxelorException((Model)address, 3, "Missing country");
        }
        return address;
    }

    @Override
    public Address getCompanyAddress(StockMove stockMove) throws AxelorException {
        Address address;
        if (stockMove.getTypeSelect() == 2) {
            address = this.getFromAddress(stockMove);
        } else if (stockMove.getTypeSelect() == 3) {
            address = this.getToAddress(stockMove);
        } else {
            throw new AxelorException((Model)((Object)stockMove), 5, I18n.get((String)"Bad stock move type"));
        }
        if (address.getAddressL7Country() == null) {
            throw new AxelorException((Model)address, 3, "Missing country");
        }
        if (address.getCity() == null || address.getCity().getDepartment() == null || StringUtils.isBlank((CharSequence)address.getCity().getDepartment().getCode())) {
            throw new AxelorException((Model)address, 3, "Missing department");
        }
        return address;
    }
}

