/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockRules;
import com.axelor.apps.stock.db.repo.StockRulesRepository;
import com.axelor.apps.stock.service.StockRulesService;
import com.axelor.exception.AxelorException;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;

public class StockRulesServiceImpl
implements StockRulesService {
    protected StockRulesRepository stockRuleRepo;

    @Inject
    public StockRulesServiceImpl(StockRulesRepository stockRuleRepo) {
        this.stockRuleRepo = stockRuleRepo;
    }

    @Override
    public void generateOrder(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type) throws AxelorException {
        this.generatePurchaseOrder(product, qty, stockLocationLine, type);
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public void generatePurchaseOrder(Product product, BigDecimal qty, StockLocationLine stockLocationLine, int type) throws AxelorException {
        StockLocation stockLocation = stockLocationLine.getStockLocation();
        if (stockLocation == null) {
            return;
        }
        StockRules stockRules = this.getStockRules(product, stockLocation, type, 2);
        if (stockRules == null) {
            return;
        }
        if (!this.useMinStockRules(stockLocationLine, stockRules, qty, type) || stockRules.getOrderAlertSelect() == 1) {
            // empty if block
        }
    }

    @Override
    public BigDecimal getQtyToOrder(BigDecimal qty, StockLocationLine stockLocationLine, int type, StockRules stockRules, BigDecimal minReorderQty) {
        minReorderQty = minReorderQty.max(stockRules.getReOrderQty());
        BigDecimal stockLocationLineQty = type == 1 ? stockLocationLine.getCurrentQty() : stockLocationLine.getFutureQty();
        BigDecimal qtyToOrder = stockLocationLineQty.subtract(qty);
        BigDecimal targetQty = stockRules.getUseIdealQty() != false ? stockRules.getIdealQty() : stockRules.getMinQty();
        qtyToOrder = targetQty.subtract(qtyToOrder);
        qtyToOrder = qtyToOrder.max(minReorderQty);
        if (stockRules.getUseMaxQty().booleanValue()) {
            BigDecimal maxQtyToReorder = stockRules.getMaxQty().subtract(stockLocationLineQty);
            qtyToOrder = qtyToOrder.min(maxQtyToReorder);
        }
        return qtyToOrder;
    }

    @Override
    public BigDecimal getQtyToOrder(BigDecimal qty, StockLocationLine stockLocationLine, int type, StockRules stockRules) {
        return this.getQtyToOrder(qty, stockLocationLine, type, stockRules, BigDecimal.ZERO);
    }

    @Override
    public boolean useMinStockRules(StockLocationLine stockLocationLine, StockRules stockRules, BigDecimal qty, int type) {
        BigDecimal currentQty = stockLocationLine.getCurrentQty();
        BigDecimal futureQty = stockLocationLine.getFutureQty();
        BigDecimal minQty = stockRules.getMinQty();
        return type == 1 ? currentQty.compareTo(minQty) >= 0 && currentQty.subtract(qty).compareTo(minQty) == -1 : type == 2 && futureQty.compareTo(minQty) >= 0 && futureQty.subtract(qty).compareTo(minQty) == -1;
    }

    @Override
    public StockRules getStockRules(Product product, StockLocation stockLocation, int type, int useCase) {
        if (useCase == 1) {
            return (StockRules)((Object)this.stockRuleRepo.all().filter("self.product = ?1 AND self.stockLocation = ?2 AND self.useCaseSelect = ?3", new Object[]{product, stockLocation, useCase}).fetchOne());
        }
        if (useCase == 2) {
            return (StockRules)((Object)this.stockRuleRepo.all().filter("self.product = ?1 AND self.stockLocation = ?2 AND self.useCaseSelect = ?3 AND self.typeSelect = ?4", new Object[]{product, stockLocation, useCase, type}).fetchOne());
        }
        return null;
    }
}

