/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service.config;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.stock.db.StockConfig;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;

public class StockConfigService {
    public StockConfig getStockConfig(Company company) throws AxelorException {
        StockConfig stockConfig = company.getStockConfig();
        if (stockConfig == null) {
            throw new AxelorException((Model)((Object)company), 4, I18n.get((String)"You must configure a Stock module for the company %s"), new Object[]{company.getName()});
        }
        return stockConfig;
    }

    public StockLocation getInventoryVirtualStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getInventoryVirtualStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure an inventory virtual stock location for the company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getInventoryVirtualStockLocation();
    }

    public StockLocation getSupplierVirtualStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getSupplierVirtualStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a supplier virtual stock location for the company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getSupplierVirtualStockLocation();
    }

    public StockLocation getCustomerVirtualStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getCustomerVirtualStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a customer virtual stock location for the company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getCustomerVirtualStockLocation();
    }

    public StockLocation getReceiptDefaultStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getReceiptDefaultStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a default receipt stock location for the company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getReceiptDefaultStockLocation();
    }

    public StockLocation getPickupDefaultStockLocation(StockConfig stockConfig) throws AxelorException {
        if (stockConfig.getPickupDefaultStockLocation() == null) {
            throw new AxelorException((Model)((Object)stockConfig), 4, I18n.get((String)"You must configure a default pickup stock location for the company %s"), new Object[]{stockConfig.getCompany().getName()});
        }
        return stockConfig.getPickupDefaultStockLocation();
    }
}

