/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.service.stockmove.print;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.service.stockmove.print.ConformityCertificatePrintService;
import com.axelor.apps.tool.ModelTool;
import com.axelor.apps.tool.ThrowConsumer;
import com.axelor.apps.tool.file.PdfTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import java.io.File;
import java.io.IOException;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ConformityCertificatePrintServiceImpl
implements ConformityCertificatePrintService {
    @Override
    public String printConformityCertificates(List<Long> ids) throws IOException {
        final ArrayList printedConformityCertificates = new ArrayList();
        ModelTool.apply(StockMove.class, ids, (ThrowConsumer)new ThrowConsumer<StockMove>(){

            public void accept(StockMove stockMove) throws Exception {
                printedConformityCertificates.add(ConformityCertificatePrintServiceImpl.this.print(stockMove, "pdf"));
            }
        });
        String fileName = this.getConformityCertificateFilesName(true, "pdf");
        return PdfTool.mergePdfToFileLink(printedConformityCertificates, (String)fileName);
    }

    @Override
    public ReportSettings prepareReportSettings(StockMove stockMove, String format) throws AxelorException {
        if (stockMove.getPrintingSettings() == null) {
            throw new AxelorException(1, String.format(I18n.get((String)"Please fill printing settings on following stock moves: %s"), stockMove.getStockMoveSeq()), new Object[]{stockMove});
        }
        String locale = ReportSettings.getPrintingLocale((Partner)stockMove.getPartner());
        String title = this.getFileName(stockMove);
        ReportSettings reportSetting = ReportFactory.createReport((String)"ConformityCertificate.rptdesign", (String)(title + " - ${date}"));
        return reportSetting.addParam("StockMoveId", (Object)stockMove.getId()).addParam("Timezone", stockMove.getCompany() != null ? stockMove.getCompany().getTimezone() : null).addParam("Locale", (Object)locale).addParam("HeaderHeight", (Object)stockMove.getPrintingSettings().getPdfHeaderHeight()).addParam("FooterHeight", (Object)stockMove.getPrintingSettings().getPdfFooterHeight()).addFormat(format);
    }

    @Override
    public File print(StockMove stockMove, String format) throws AxelorException {
        ReportSettings reportSettings = this.prepareReportSettings(stockMove, format);
        return reportSettings.generate().getFile();
    }

    @Override
    public String printConformityCertificate(StockMove stockMove, String format) throws AxelorException, IOException {
        String fileName = this.getConformityCertificateFilesName(false, "pdf");
        return PdfTool.getFileLinkFromPdfFile((File)this.print(stockMove, format), (String)fileName);
    }

    public String getConformityCertificateFilesName(boolean plural, String format) {
        return I18n.get((String)(plural ? "Conformity Certificates" : "Certificate of conformity")) + " - " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate((Company)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null)).format(DateTimeFormatter.BASIC_ISO_DATE) + "." + format;
    }

    @Override
    public String getFileName(StockMove stockMove) {
        return I18n.get((String)"Certificate of conformity") + " " + stockMove.getStockMoveSeq();
    }
}

