/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.Inventory;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.InventoryRepository;
import com.axelor.apps.stock.service.InventoryService;
import com.axelor.db.JPA;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.List;
import javax.persistence.NoResultException;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InventoryController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void showInventory(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
            String name = I18n.get((String)"Inventory") + " " + inventory.getInventorySeq();
            String fileLink = ReportFactory.createReport((String)"Inventory.rptdesign", (String)(name + "-${date}")).addParam("InventoryId", (Object)inventory.getId()).addParam("Timezone", inventory.getCompany() != null ? inventory.getCompany().getTimezone() : null).addParam("Locale", (Object)ReportSettings.getPrintingLocale(null)).addParam("activateBarCodeGeneration", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getActivateBarCodeGeneration()).addFormat(inventory.getFormatSelect()).generate().getFileLink();
            this.logger.debug("Printing " + name);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void exportInventory(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
            inventory = (Inventory)((Object)((InventoryRepository)((Object)Beans.get(InventoryRepository.class))).find(inventory.getId()));
            String name = I18n.get((String)"Inventory") + " " + inventory.getInventorySeq();
            MetaFile metaFile = ((InventoryService)Beans.get(InventoryService.class)).exportInventoryAsCSV(inventory);
            response.setView(ActionView.define((String)name).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + metaFile.getId() + "/content/download?v=" + metaFile.getVersion()).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void importFile(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)((InventoryRepository)((Object)Beans.get(InventoryRepository.class))).find(((Inventory)((Object)request.getContext().asType(Inventory.class))).getId()));
            Path filePath = ((InventoryService)Beans.get(InventoryService.class)).importFile(inventory);
            response.setFlash(String.format(I18n.get((String)"File %s successfully imported."), filePath.toString()));
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validateInventory(ActionRequest request, ActionResponse response) {
        try {
            Long id = ((Inventory)((Object)request.getContext().asType(Inventory.class))).getId();
            Inventory inventory = (Inventory)((Object)((InventoryRepository)((Object)Beans.get(InventoryRepository.class))).find(id));
            ((InventoryService)Beans.get(InventoryService.class)).validateInventory(inventory);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
            inventory = (Inventory)((Object)((InventoryRepository)((Object)Beans.get(InventoryRepository.class))).find(inventory.getId()));
            ((InventoryService)Beans.get(InventoryService.class)).cancel(inventory);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void fillInventoryLineList(ActionRequest request, ActionResponse response) {
        try {
            Long inventoryId = (Long)request.getContext().get((Object)"id");
            if (inventoryId != null) {
                Inventory inventory = (Inventory)((Object)((InventoryRepository)((Object)Beans.get(InventoryRepository.class))).find(inventoryId));
                Boolean succeed = ((InventoryService)Beans.get(InventoryService.class)).fillInventoryLineList(inventory);
                if (succeed == null) {
                    response.setFlash(I18n.get((String)"There's no product in stock location."));
                } else if (succeed.booleanValue()) {
                    response.setNotify(I18n.get((String)"Inventory's lines' list has been filled."));
                } else {
                    response.setNotify(I18n.get((String)"No inventory lines has been created."));
                }
            }
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setInventorySequence(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
            SequenceService sequenceService = (SequenceService)Beans.get(SequenceService.class);
            if (sequenceService.isEmptyOrDraftSequenceNumber(inventory.getInventorySeq())) {
                StockLocation stockLocation = inventory.getStockLocation();
                response.setValue("inventorySeq", (Object)((InventoryService)Beans.get(InventoryService.class)).getInventorySequence(stockLocation.getCompany()));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showStockMoves(ActionRequest request, ActionResponse response) {
        try {
            Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
            List<StockMove> stockMoveList = ((InventoryService)Beans.get(InventoryService.class)).findStockMoves(inventory);
            ActionView.ActionViewBuilder builder = ActionView.define((String)I18n.get((String)"Internal Stock Moves")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("search-filters", "internal-stock-move-filters");
            if (stockMoveList.isEmpty()) {
                response.setFlash(I18n.get((String)"No stock moves found for this inventory."));
            } else {
                builder.context("_showSingle", (Object)true).domain(String.format("self.originTypeSelect = '%s' AND self.originId = %s", "com.axelor.apps.stock.db.Inventory", inventory.getId()));
                response.setView(builder.map());
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkDuplicateProduct(ActionRequest request, ActionResponse response) throws AxelorException {
        Inventory inventory = (Inventory)((Object)request.getContext().asType(Inventory.class));
        Query query = JPA.em().createQuery("select COUNT(*) FROM InventoryLine self WHERE self.inventory.id = :invent GROUP BY self.product, self.trackingNumber HAVING COUNT(self) > 1");
        try {
            query.setParameter("invent", (Object)inventory.getId()).getSingleResult();
            throw new AxelorException(4, I18n.get((String)"There is more than one line for same product with same tracking number."));
        }
        catch (NoResultException noResultException) {
            return;
        }
    }
}

