/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.LogisticalFormRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.exception.LogisticalFormError;
import com.axelor.apps.stock.exception.LogisticalFormWarning;
import com.axelor.apps.stock.service.LogisticalFormService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.Map;
import java.util.Optional;

@Singleton
public class LogisticalFormController {
    public void addStockMove(ActionRequest request, ActionResponse response) {
        try {
            Map stockMoveMap = (Map)request.getContext().get((Object)"stockMove");
            if (stockMoveMap != null) {
                StockMove stockMove = (StockMove)((Object)Mapper.toBean(StockMove.class, (Map)stockMoveMap));
                stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).find(stockMove.getId()));
                if (stockMove.getStockMoveLineList() != null) {
                    LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
                    LogisticalFormService logisticalFormService = (LogisticalFormService)Beans.get(LogisticalFormService.class);
                    logisticalFormService.addDetailLines(logisticalForm, stockMove);
                    response.setValue("logisticalFormLineList", logisticalForm.getLogisticalFormLineList());
                    response.setValue("$stockMove", null);
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTotals(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            ((LogisticalFormService)Beans.get(LogisticalFormService.class)).computeTotals(logisticalForm);
            response.setValue("totalNetMass", (Object)logisticalForm.getTotalNetMass());
            response.setValue("totalGrossMass", (Object)logisticalForm.getTotalGrossMass());
            response.setValue("totalVolume", (Object)logisticalForm.getTotalVolume());
        }
        catch (LogisticalFormError e) {
            response.setError(e.getLocalizedMessage());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void checkLines(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            LogisticalFormService logisticalFormService = (LogisticalFormService)Beans.get(LogisticalFormService.class);
            logisticalFormService.sortLines(logisticalForm);
            logisticalFormService.checkLines(logisticalForm);
        }
        catch (LogisticalFormWarning e) {
            response.setAlert(e.getLocalizedMessage());
        }
        catch (LogisticalFormError e) {
            response.setError(e.getLocalizedMessage());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setStockMoveDomain(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            String domain = ((LogisticalFormService)Beans.get(LogisticalFormService.class)).getStockMoveDomain(logisticalForm);
            response.setAttr("$stockMove", "domain", (Object)domain);
            if (logisticalForm.getDeliverToCustomerPartner() == null) {
                response.setNotify(I18n.get((String)"Deliver to customer is not set."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void processCollected(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            logisticalForm = (LogisticalForm)((Object)((LogisticalFormRepository)((Object)Beans.get(LogisticalFormRepository.class))).find(logisticalForm.getId()));
            ((LogisticalFormService)Beans.get(LogisticalFormService.class)).processCollected(logisticalForm);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setCustomerAccountNumberToCarrier(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            Optional<String> customerAccountNumberToCarrier = ((LogisticalFormService)Beans.get(LogisticalFormService.class)).getCustomerAccountNumberToCarrier(logisticalForm);
            response.setValue("customerAccountNumberToCarrier", customerAccountNumberToCarrier.orElse(null));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void refreshProductNetMass(ActionRequest request, ActionResponse response) {
        try {
            LogisticalForm logisticalForm = (LogisticalForm)((Object)request.getContext().asType(LogisticalForm.class));
            LogisticalFormService logisticalFormService = (LogisticalFormService)Beans.get(LogisticalFormService.class);
            logisticalFormService.updateProductNetMass(logisticalForm);
            response.setValue("logisticalFormLineList", logisticalForm.getLogisticalFormLineList());
            response.setValue("totalNetMass", (Object)logisticalForm.getTotalNetMass());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

