/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.stock.db.LogisticalForm;
import com.axelor.apps.stock.db.LogisticalFormLine;
import com.axelor.apps.stock.service.LogisticalFormLineService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.math.BigDecimal;

@Singleton
public class LogisticalFormLineController {
    public void setQty(ActionRequest request, ActionResponse response) {
        try {
            LogisticalFormLine logisticalFormLine = this.getLogisticalFormLine(request);
            if (logisticalFormLine.getQty() == null) {
                BigDecimal qty = ((LogisticalFormLineService)Beans.get(LogisticalFormLineService.class)).getUnspreadQty(logisticalFormLine);
                response.setValue("qty", (Object)qty);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setStockMoveLineDomain(ActionRequest request, ActionResponse response) {
        try {
            LogisticalFormLine logisticalFormLine = this.getLogisticalFormLine(request);
            String domain = ((LogisticalFormLineService)Beans.get(LogisticalFormLineService.class)).getStockMoveLineDomain(logisticalFormLine);
            response.setAttr("stockMoveLine", "domain", (Object)domain);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void initParcelPallet(ActionRequest request, ActionResponse response) {
        try {
            LogisticalFormLine logisticalFormLine = this.getLogisticalFormLine(request);
            ((LogisticalFormLineService)Beans.get(LogisticalFormLineService.class)).initParcelPallet(logisticalFormLine);
            response.setValue("parcelPalletNumber", (Object)logisticalFormLine.getParcelPalletNumber());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private LogisticalFormLine getLogisticalFormLine(ActionRequest request) {
        LogisticalFormLine logisticalFormLine = (LogisticalFormLine)((Object)request.getContext().asType(LogisticalFormLine.class));
        if (logisticalFormLine.getLogisticalForm() == null) {
            logisticalFormLine.setLogisticalForm((LogisticalForm)((Object)request.getContext().getParent().asType(LogisticalForm.class)));
        }
        return logisticalFormLine;
    }
}

