/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMoveLine;
import com.axelor.apps.stock.service.StockLocationLineService;
import com.axelor.apps.stock.service.StockMoveService;
import com.axelor.apps.stock.service.WeightedAveragePriceService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.time.LocalDate;
import java.util.List;
import java.util.Map;

@Singleton
public class ProductStockController {
    public void setStockPerDay(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        Long productId = Long.parseLong(context.get((Object)"id").toString());
        Long locationId = Long.parseLong(context.get((Object)"locationId").toString());
        LocalDate fromDate = LocalDate.parse(context.get((Object)"stockFromDate").toString());
        LocalDate toDate = LocalDate.parse(context.get((Object)"stockToDate").toString());
        List<Map<String, Object>> stocks = ((StockMoveService)Beans.get(StockMoveService.class)).getStockPerDate(locationId, productId, fromDate, toDate);
        response.setValue("$stockPerDayList", stocks);
    }

    public void displayStockMoveLine(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        if (context.get((Object)"date") != null && context.getParent().get((Object)"locationId") != null) {
            LocalDate stockDate = LocalDate.parse(context.get((Object)"date").toString());
            Long locationId = Long.parseLong(context.getParent().get((Object)"locationId").toString());
            if (request.getContext().getParent().get((Object)"id") != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Stock Move Lines")).model(StockMoveLine.class.getName()).add("grid", "stock-move-line-all-grid").add("form", "stock-move-line-all-form").param("search-filters", "stock-move-line-filters").domain("self.product.id = :id AND (self.stockMove.fromStockLocation.id = :locationId OR self.stockMove.toStockLocation.id = :locationId) AND self.stockMove.statusSelect != :status AND (self.stockMove.estimatedDate <= :stockDate OR self.stockMove.realDate <= :stockDate)").context("id", request.getContext().getParent().get((Object)"id")).context("locationId", (Object)locationId).context("status", (Object)4).context("stockDate", (Object)stockDate).map());
            }
            response.setCanClose(true);
        }
    }

    public void updateStockLocation(ActionRequest request, ActionResponse response) {
        try {
            Product product = (Product)((Object)request.getContext().asType(Product.class));
            StockLocationLineService stockLocationLineService = (StockLocationLineService)Beans.get(StockLocationLineService.class);
            if (product.getId() == null) {
                return;
            }
            product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(product.getId()));
            List<StockLocationLine> stockLocationLineList = stockLocationLineService.getStockLocationLines(product);
            for (StockLocationLine stockLocationLine : stockLocationLineList) {
                stockLocationLineService.updateStockLocationFromProduct(stockLocationLine, product);
            }
            ((WeightedAveragePriceService)Beans.get(WeightedAveragePriceService.class)).computeAvgPriceForProduct(product);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

