/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.stock.db.StockCorrection;
import com.axelor.apps.stock.db.StockLocationLine;
import com.axelor.apps.stock.db.StockMove;
import com.axelor.apps.stock.db.repo.StockCorrectionRepository;
import com.axelor.apps.stock.db.repo.StockLocationLineRepository;
import com.axelor.apps.stock.db.repo.StockMoveRepository;
import com.axelor.apps.stock.service.StockCorrectionService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.util.Map;

@Singleton
public class StockCorrectionController {
    public void setDefaultDetails(ActionRequest request, ActionResponse response) {
        try {
            Long stockLocaLocationLineId = Long.valueOf(request.getContext().get((Object)"_stockLocationLineId").toString());
            StockLocationLine stockLocationLine = (StockLocationLine)((Object)((StockLocationLineRepository)((Object)Beans.get(StockLocationLineRepository.class))).find(stockLocaLocationLineId));
            if (stockLocationLine != null) {
                Map<String, Object> stockCorrectionDetails = ((StockCorrectionService)Beans.get(StockCorrectionService.class)).fillDefaultValues(stockLocationLine);
                response.setValues(stockCorrectionDetails);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void setDefaultQtys(ActionRequest request, ActionResponse response) {
        try {
            StockCorrection stockCorrection = (StockCorrection)((Object)request.getContext().asType(StockCorrection.class));
            Map<String, Object> stockCorrectionQtys = ((StockCorrectionService)Beans.get(StockCorrectionService.class)).fillDeafultQtys(stockCorrection);
            response.setValues(stockCorrectionQtys);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            Long id = ((StockCorrection)((Object)request.getContext().asType(StockCorrection.class))).getId();
            StockCorrection stockCorrection = (StockCorrection)((Object)((StockCorrectionRepository)((Object)Beans.get(StockCorrectionRepository.class))).find(id));
            boolean success = ((StockCorrectionService)Beans.get(StockCorrectionService.class)).validate(stockCorrection);
            if (success) {
                response.setReload(true);
            } else {
                response.setError(I18n.get((String)"No stock correction needed, current quantity in stock equals real quantity."));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void showGeneratedStockMove(ActionRequest request, ActionResponse response) {
        try {
            Long stockCorrectionId = ((StockCorrection)((Object)request.getContext().asType(StockCorrection.class))).getId();
            StockMove stockMove = (StockMove)((Object)((StockMoveRepository)((Object)Beans.get(StockMoveRepository.class))).all().filter("self.originTypeSelect = ? AND self.originId = ?", new Object[]{"com.axelor.apps.stock.db.StockCorrection", stockCorrectionId}).fetchOne());
            if (stockMove != null) {
                response.setView(ActionView.define((String)I18n.get((String)"Stock move")).model(StockMove.class.getName()).add("grid", "stock-move-grid").add("form", "stock-move-form").param("search-filters", "internal-stock-move-filters").context("_showRecord", (Object)stockMove.getId().toString()).map());
            } else {
                response.setFlash(I18n.get((String)"No record found"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

