/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.stock.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.stock.db.StockLocation;
import com.axelor.apps.stock.db.repo.StockLocationRepository;
import com.axelor.apps.stock.service.StockLocationService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class StockLocationController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        Set<Long> idSet;
        Context context = request.getContext();
        LinkedHashMap stockLocationMap = (LinkedHashMap)context.get((Object)"_stockLocation");
        Integer stockLocationId = (Integer)stockLocationMap.get("id");
        StockLocationService stockLocationService = (StockLocationService)Beans.get(StockLocationService.class);
        StockLocationRepository stockLocationRepository = (StockLocationRepository)((Object)Beans.get(StockLocationRepository.class));
        StockLocation stockLocation = stockLocationId != null ? (StockLocation)((Object)stockLocationRepository.find(new Long(stockLocationId.intValue()))) : null;
        String locationIds = "";
        String printType = (String)context.get((Object)"printingType");
        String exportType = (String)context.get((Object)"exportTypeSelect");
        List lstSelectedLocations = (List)context.get((Object)"_ids");
        if (lstSelectedLocations != null) {
            for (Integer it : lstSelectedLocations) {
                Set<Long> idSet2 = stockLocationService.getContentStockLocationIds((StockLocation)((Object)stockLocationRepository.find(new Long(it.intValue()))));
                if (idSet2.isEmpty()) continue;
                locationIds = locationIds + Joiner.on((String)",").join(idSet2) + ",";
            }
        }
        if (!locationIds.equals("")) {
            locationIds = locationIds.substring(0, locationIds.length() - 1);
            stockLocation = (StockLocation)((Object)stockLocationRepository.find(new Long(((Integer)lstSelectedLocations.get(0)).intValue())));
        } else if (stockLocation != null && stockLocation.getId() != null && !(idSet = stockLocationService.getContentStockLocationIds((StockLocation)((Object)stockLocationRepository.find(stockLocation.getId())))).isEmpty()) {
            locationIds = Joiner.on((String)",").join(idSet);
        }
        if (!locationIds.equals("")) {
            String language = ReportSettings.getPrintingLocale(null);
            String title = I18n.get((String)"Stock location");
            if (stockLocation.getName() != null) {
                String string = title = lstSelectedLocations == null ? I18n.get((String)"Stock location") + " " + stockLocation.getName() : I18n.get((String)"Stock location(s)");
            }
            if (stockLocationService.isConfigMissing(stockLocation, Integer.parseInt(printType))) {
                response.setNotify(I18n.get((String)"Configuration is missing in stock configuration to see financial data"));
            }
            String fileLink = ReportFactory.createReport((String)"StockLocation.rptdesign", (String)(title + "-${date}")).addParam("StockLocationId", (Object)locationIds).addParam("Timezone", null).addParam("Locale", (Object)language).addFormat(exportType).addParam("PrintType", (Object)printType).generate().getFileLink();
            this.logger.debug("Printing " + title);
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        } else {
            response.setFlash(I18n.get((String)"Please select the Stock Location(s) to print."));
        }
        response.setCanClose(true);
    }

    public void setStocklocationValue(ActionRequest request, ActionResponse response) {
        StockLocation stockLocation = (StockLocation)((Object)request.getContext().asType(StockLocation.class));
        response.setValue("stockLocationValue", (Object)((StockLocationService)Beans.get(StockLocationService.class)).getStockLocationValue(stockLocation));
    }

    public void openPrintWizard(ActionRequest request, ActionResponse response) {
        StockLocation stockLocation = (StockLocation)((Object)request.getContext().asType(StockLocation.class));
        List lstSelectedLocations = (List)request.getContext().get((Object)"_ids");
        response.setView(ActionView.define((String)I18n.get((String)"Select format to Export")).model(Wizard.class.getName()).add("form", "stock-location-print-wizard-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_ids", (Object)lstSelectedLocations).context("_stockLocation", (Object)stockLocation).map());
    }
}

