/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.annotation.handler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.annotation.handler.PluginAnnotation;
import org.hotswap.agent.annotation.handler.WatchEventDTO;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.javassist.ClassPool;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.LoaderClassPath;
import org.hotswap.agent.javassist.NotFoundException;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.IOUtils;
import org.hotswap.agent.watch.WatchFileEvent;

public class WatchEventCommand<T extends Annotation>
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(WatchEventCommand.class);
    private final PluginAnnotation<T> pluginAnnotation;
    private final WatchEventDTO watchEventDTO;
    private final WatchFileEvent event;
    private final ClassLoader classLoader;

    public static <T extends Annotation> WatchEventCommand<T> createCmdForEvent(PluginAnnotation<T> pluginAnnotation, WatchFileEvent event, ClassLoader classLoader) {
        WatchEventDTO watchEventDTO = WatchEventDTO.parse(pluginAnnotation.getAnnotation());
        if (!watchEventDTO.accept(event)) {
            return null;
        }
        if (watchEventDTO.isOnlyRegularFiles() && !event.isFile()) {
            LOGGER.trace("Skipping URI {} because it is not a regular file.", event.getURI());
            return null;
        }
        if (!Arrays.asList(watchEventDTO.getEvents()).contains((Object)event.getEventType())) {
            LOGGER.trace("Skipping URI {} because it is not a requested event.", event.getURI());
            return null;
        }
        if (watchEventDTO.getFilter() != null && watchEventDTO.getFilter().length() > 0 && !event.getURI().toString().matches(watchEventDTO.getFilter())) {
            LOGGER.trace("Skipping URI {} because it does not match filter.", event.getURI(), watchEventDTO.getFilter());
            return null;
        }
        return new WatchEventCommand<T>(pluginAnnotation, event, classLoader, watchEventDTO);
    }

    private WatchEventCommand(PluginAnnotation<T> pluginAnnotation, WatchFileEvent event, ClassLoader classLoader, WatchEventDTO watchEventDTO) {
        this.pluginAnnotation = pluginAnnotation;
        this.event = event;
        this.classLoader = classLoader;
        this.watchEventDTO = watchEventDTO;
    }

    @Override
    public void executeCommand() {
        LOGGER.trace("Executing for pluginAnnotation={}, event={} at classloader {}", this.pluginAnnotation, this.event, this.classLoader);
        this.onWatchEvent(this.pluginAnnotation, this.event, this.classLoader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchEventCommand that = (WatchEventCommand)o;
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        if (this.event != null ? !this.event.equals(that.event) : that.event != null) {
            return false;
        }
        return !(this.pluginAnnotation != null ? !this.pluginAnnotation.equals(that.pluginAnnotation) : that.pluginAnnotation != null);
    }

    public int hashCode() {
        int result = this.pluginAnnotation != null ? this.pluginAnnotation.hashCode() : 0;
        result = 31 * result + (this.event != null ? this.event.hashCode() : 0);
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "WatchEventCommand{pluginAnnotation=" + this.pluginAnnotation + ", event=" + this.event + ", classLoader=" + this.classLoader + '}';
    }

    public void onWatchEvent(PluginAnnotation<T> pluginAnnotation, WatchFileEvent event, ClassLoader classLoader) {
        T annot = pluginAnnotation.getAnnotation();
        Object plugin = pluginAnnotation.getPlugin();
        CtClass ctClass = null;
        if (this.watchEventDTO.isClassFileEvent()) {
            try {
                ctClass = this.createCtClass(event.getURI(), classLoader);
            }
            catch (Exception e) {
                LOGGER.error("Unable create CtClass for URI '{}'.", e, event.getURI());
                return;
            }
            if (ctClass == null || !ctClass.getName().matches(this.watchEventDTO.getClassNameRegexp())) {
                return;
            }
        }
        LOGGER.debug("Executing resource changed method {} on class {} for event {}", pluginAnnotation.getMethod().getName(), plugin.getClass().getName(), event);
        ArrayList<Object> args = new ArrayList<Object>();
        for (Class<Object> clazz : pluginAnnotation.getMethod().getParameterTypes()) {
            if (clazz.isAssignableFrom(ClassLoader.class)) {
                args.add(classLoader);
                continue;
            }
            if (clazz.isAssignableFrom(URI.class)) {
                args.add(event.getURI());
                continue;
            }
            if (clazz.isAssignableFrom(URL.class)) {
                try {
                    args.add(event.getURI().toURL());
                    continue;
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unable to convert URI '{}' to URL.", e, event.getURI());
                    return;
                }
            }
            if (clazz.isAssignableFrom(ClassPool.class)) {
                args.add(ClassPool.getDefault());
                continue;
            }
            if (clazz.isAssignableFrom(FileEvent.class)) {
                args.add((Object)event.getEventType());
                continue;
            }
            if (this.watchEventDTO.isClassFileEvent() && clazz.isAssignableFrom(CtClass.class)) {
                args.add(ctClass);
                continue;
            }
            if (this.watchEventDTO.isClassFileEvent() && clazz.isAssignableFrom(String.class)) {
                args.add(ctClass != null ? ctClass.getName() : null);
                continue;
            }
            LOGGER.error("Unable to call method {} on plugin {}. Method parameter type {} is not recognized.", pluginAnnotation.getMethod().getName(), plugin.getClass().getName(), clazz);
            return;
        }
        try {
            pluginAnnotation.getMethod().invoke(plugin, args.toArray());
            if (ctClass != null) {
                ctClass.detach();
            }
        }
        catch (IllegalAccessException e) {
            LOGGER.error("IllegalAccessException in method {} on plugin {}", e, pluginAnnotation.getMethod().getName(), plugin.getClass().getName());
        }
        catch (InvocationTargetException e) {
            LOGGER.error("InvocationTargetException in method {} on plugin {}", e, pluginAnnotation.getMethod().getName(), plugin.getClass().getName());
        }
    }

    private CtClass createCtClass(URI uri, ClassLoader classLoader) throws NotFoundException, IOException {
        ClassPool cp = new ClassPool();
        cp.appendClassPath(new LoaderClassPath(classLoader));
        return cp.makeClass(new ByteArrayInputStream(IOUtils.toByteArray(uri)));
    }
}

