/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.command.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hotswap.agent.annotation.handler.WatchEventCommand;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.command.Scheduler;
import org.hotswap.agent.command.impl.CommandExecutor;
import org.hotswap.agent.logging.AgentLogger;

public class SchedulerImpl
implements Scheduler {
    private static AgentLogger LOGGER = AgentLogger.getLogger(SchedulerImpl.class);
    int DEFAULT_SCHEDULING_TIMEOUT = 100;
    final Map<Command, DuplicateScheduleConfig> scheduledCommands = new ConcurrentHashMap<Command, DuplicateScheduleConfig>();
    final Set<Command> runningCommands = Collections.synchronizedSet(new HashSet());
    Thread runner;
    boolean stopped;

    @Override
    public void scheduleCommand(Command command) {
        this.scheduleCommand(command, this.DEFAULT_SCHEDULING_TIMEOUT);
    }

    @Override
    public void scheduleCommand(Command command, int timeout) {
        this.scheduleCommand(command, timeout, Scheduler.DuplicateSheduleBehaviour.WAIT_AND_RUN_AFTER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void scheduleCommand(Command command, int timeout, Scheduler.DuplicateSheduleBehaviour behaviour) {
        Map<Command, DuplicateScheduleConfig> map = this.scheduledCommands;
        synchronized (map) {
            Command targetCommand = command;
            if (this.scheduledCommands.containsKey(command) && command instanceof MergeableCommand) {
                for (Command scheduledCommand : this.scheduledCommands.keySet()) {
                    if (!command.equals(scheduledCommand)) continue;
                    targetCommand = ((MergeableCommand)command).merge(scheduledCommand);
                    break;
                }
            }
            this.scheduledCommands.put(targetCommand, new DuplicateScheduleConfig(System.currentTimeMillis() + (long)timeout, behaviour));
            LOGGER.trace("{} scheduled for execution in {}ms", targetCommand, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processCommands() {
        Long currentTime = System.currentTimeMillis();
        Map<Command, DuplicateScheduleConfig> map = this.scheduledCommands;
        synchronized (map) {
            Iterator<Map.Entry<Command, DuplicateScheduleConfig>> it = this.scheduledCommands.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Command, DuplicateScheduleConfig> entry = it.next();
                DuplicateScheduleConfig config = entry.getValue();
                Command command = entry.getKey();
                if (config.getTime() >= currentTime) continue;
                if (this.runningCommands.contains(command)) {
                    if (config.getBehaviour().equals((Object)Scheduler.DuplicateSheduleBehaviour.SKIP)) {
                        LOGGER.debug("Skipping duplicate running command {}", command);
                        it.remove();
                        continue;
                    }
                    if (!config.getBehaviour().equals((Object)Scheduler.DuplicateSheduleBehaviour.RUN_DUPLICATE)) continue;
                    this.executeCommand(command);
                    it.remove();
                    continue;
                }
                this.executeCommand(command);
                it.remove();
            }
        }
        return true;
    }

    private void executeCommand(Command command) {
        if (command instanceof WatchEventCommand) {
            LOGGER.trace("Executing {}", command);
        } else {
            LOGGER.debug("Executing {}", command);
        }
        this.runningCommands.add(command);
        new CommandExecutor(command){

            @Override
            public void finished() {
                SchedulerImpl.this.runningCommands.remove(this.command);
            }
        }.start();
    }

    @Override
    public void run() {
        this.runner = new Thread(){

            @Override
            public void run() {
                while (!SchedulerImpl.this.stopped && SchedulerImpl.this.processCommands()) {
                    try {
                        2.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                }
            }
        };
        this.runner.setDaemon(true);
        this.runner.start();
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    private static class DuplicateScheduleConfig {
        long time;
        Scheduler.DuplicateSheduleBehaviour behaviour;

        private DuplicateScheduleConfig(long time, Scheduler.DuplicateSheduleBehaviour behaviour) {
            this.time = time;
            this.behaviour = behaviour;
        }

        public long getTime() {
            return this.time;
        }

        public Scheduler.DuplicateSheduleBehaviour getBehaviour() {
            return this.behaviour;
        }
    }
}

