/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import org.hotswap.agent.annotation.handler.PluginClassFileTransformer;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;

public class HotswapTransformer
implements ClassFileTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(HotswapTransformer.class);
    private static final Set<String> excludedClassLoaders = new HashSet<String>(Arrays.asList("sun.reflect.DelegatingClassLoader", "org.apache.felix.framework.BundleWiringImpl$BundleClassLoader", "org.apache.felix.framework.BundleWiringImpl$BundleClassLoaderJava5"));
    protected Map<String, RegisteredTransformersRecord> registeredTransformers = new LinkedHashMap<String, RegisteredTransformersRecord>();
    protected Map<ClassFileTransformer, ClassLoader> classLoaderTransformers = new LinkedHashMap<ClassFileTransformer, ClassLoader>();
    protected Map<ClassLoader, Object> seenClassLoaders = new WeakHashMap<ClassLoader, Object>();
    private List<Pattern> excludedClassLoaderPatterns;

    public void setExcludedClassLoaderPatterns(List<Pattern> excludedClassLoaderPatterns) {
        this.excludedClassLoaderPatterns = excludedClassLoaderPatterns;
    }

    public void registerTransformer(ClassLoader classLoader, String classNameRegexp, ClassFileTransformer transformer) {
        LOGGER.debug("Registering transformer for class regexp '{}'.", classNameRegexp);
        String normalizeRegexp = this.normalizeTypeRegexp(classNameRegexp);
        RegisteredTransformersRecord transformerRecord = this.registeredTransformers.get(normalizeRegexp);
        if (transformerRecord == null) {
            transformerRecord = new RegisteredTransformersRecord();
            transformerRecord.pattern = Pattern.compile(normalizeRegexp);
            this.registeredTransformers.put(normalizeRegexp, transformerRecord);
        }
        transformerRecord.transformerList.add(transformer);
        if (classLoader != null) {
            this.classLoaderTransformers.put(transformer, classLoader);
        }
    }

    public void removeTransformer(String classNameRegexp, ClassFileTransformer transformer) {
        String normalizeRegexp = this.normalizeTypeRegexp(classNameRegexp);
        RegisteredTransformersRecord transformerRecord = this.registeredTransformers.get(normalizeRegexp);
        if (transformerRecord != null) {
            transformerRecord.transformerList.remove(transformer);
        }
    }

    public void closeClassLoader(ClassLoader classLoader) {
        Iterator<Map.Entry<ClassFileTransformer, ClassLoader>> entryIterator = this.classLoaderTransformers.entrySet().iterator();
        while (entryIterator.hasNext()) {
            Map.Entry<ClassFileTransformer, ClassLoader> entry = entryIterator.next();
            if (!entry.getValue().equals(classLoader)) continue;
            entryIterator.remove();
            for (RegisteredTransformersRecord transformerRecord : this.registeredTransformers.values()) {
                transformerRecord.transformerList.remove(entry.getKey());
            }
        }
        LOGGER.debug("All transformers removed for classLoader {}", classLoader);
    }

    @Override
    public byte[] transform(ClassLoader classLoader, String className, Class<?> redefiningClass, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
        LOGGER.trace("Transform on class '{}' @{} redefiningClass '{}'.", className, classLoader, redefiningClass);
        LinkedList<ClassFileTransformer> toApply = new LinkedList<ClassFileTransformer>();
        LinkedList<PluginClassFileTransformer> pluginTransformers = new LinkedList<PluginClassFileTransformer>();
        try {
            for (RegisteredTransformersRecord transformerRecord : new LinkedList<RegisteredTransformersRecord>(this.registeredTransformers.values())) {
                if ((className == null || !transformerRecord.pattern.matcher(className).matches()) && (redefiningClass == null || !transformerRecord.pattern.matcher(redefiningClass.getName()).matches())) continue;
                for (ClassFileTransformer transformer : new LinkedList<ClassFileTransformer>(transformerRecord.transformerList)) {
                    if (transformer instanceof PluginClassFileTransformer) {
                        PluginClassFileTransformer pcft = (PluginClassFileTransformer)PluginClassFileTransformer.class.cast(transformer);
                        if (pcft.isPluginDisabled(classLoader)) continue;
                        pluginTransformers.add(pcft);
                        continue;
                    }
                    toApply.add(transformer);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.error("Error transforming class '" + className + "'.", t, new Object[0]);
        }
        if (!pluginTransformers.isEmpty()) {
            pluginTransformers = this.reduce(classLoader, pluginTransformers, className);
        }
        if (toApply.isEmpty() && pluginTransformers.isEmpty()) {
            LOGGER.trace("No transformers defing for {} ", className);
            return bytes;
        }
        this.ensureClassLoaderInitialized(classLoader, protectionDomain);
        try {
            byte[] result = bytes;
            for (ClassFileTransformer classFileTransformer : pluginTransformers) {
                LOGGER.trace("Transforming class '" + className + "' with transformer '" + classFileTransformer + "' @ClassLoader" + classLoader + ".", new Object[0]);
                result = classFileTransformer.transform(classLoader, className, redefiningClass, protectionDomain, result);
            }
            for (ClassFileTransformer classFileTransformer : toApply) {
                LOGGER.trace("Transforming class '" + className + "' with transformer '" + classFileTransformer + "' @ClassLoader" + classLoader + ".", new Object[0]);
                result = classFileTransformer.transform(classLoader, className, redefiningClass, protectionDomain, result);
            }
            return result;
        }
        catch (Throwable t) {
            LOGGER.error("Error transforming class '" + className + "'.", t, new Object[0]);
            return bytes;
        }
    }

    LinkedList<PluginClassFileTransformer> reduce(ClassLoader classLoader, List<PluginClassFileTransformer> pluginCalls, String className) {
        LinkedList<PluginClassFileTransformer> reduced = new LinkedList<PluginClassFileTransformer>();
        HashMap<String, PluginClassFileTransformer> fallbackMap = new HashMap<String, PluginClassFileTransformer>();
        for (PluginClassFileTransformer pcft : pluginCalls) {
            try {
                String pluginGroup = pcft.getPluginGroup();
                if (pcft.versionMatches(classLoader)) {
                    if (pluginGroup != null) {
                        fallbackMap.put(pluginGroup, null);
                    }
                    reduced.add(pcft);
                    continue;
                }
                if (!pcft.isFallbackPlugin() || pluginGroup == null || fallbackMap.containsKey(pluginGroup)) continue;
                fallbackMap.put(pluginGroup, pcft);
            }
            catch (Exception e) {
                LOGGER.warning("Error evaluating aplicability of plugin", e, new Object[0]);
            }
        }
        for (PluginClassFileTransformer pcft : fallbackMap.values()) {
            if (pcft == null) continue;
            reduced.add(pcft);
        }
        return reduced;
    }

    protected void ensureClassLoaderInitialized(final ClassLoader classLoader, final ProtectionDomain protectionDomain) {
        if (!this.seenClassLoaders.containsKey(classLoader)) {
            this.seenClassLoaders.put(classLoader, null);
            if (classLoader == null) {
                PluginManager.getInstance().initClassLoader(null, protectionDomain);
            } else if (this.shouldScheduleClassLoader(classLoader)) {
                PluginManager.getInstance().getScheduler().scheduleCommand(new Command(){

                    @Override
                    public void executeCommand() {
                        PluginManager.getInstance().initClassLoader(classLoader, protectionDomain);
                    }

                    public String toString() {
                        return "executeCommand: initClassLoader(" + classLoader + ")";
                    }
                }, 1000);
            }
        }
    }

    private boolean shouldScheduleClassLoader(ClassLoader classLoader) {
        String name = classLoader.getClass().getName();
        if (excludedClassLoaders.contains(name)) {
            return false;
        }
        if (this.excludedClassLoaderPatterns != null) {
            for (Pattern pattern : this.excludedClassLoaderPatterns) {
                if (!pattern.matcher(name).matches()) continue;
                return false;
            }
        }
        return true;
    }

    protected String normalizeTypeRegexp(String registeredType) {
        String regexp = registeredType;
        if (!registeredType.startsWith("^")) {
            regexp = "^" + regexp;
        }
        if (!registeredType.endsWith("$")) {
            regexp = regexp + "$";
        }
        return regexp;
    }

    private static class RegisteredTransformersRecord {
        Pattern pattern;
        List<ClassFileTransformer> transformerList = new LinkedList<ClassFileTransformer>();

        private RegisteredTransformersRecord() {
        }
    }
}

