/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.util.signature;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.hotswap.agent.util.signature.ClassSignatureElement;

public abstract class ClassSignatureBase {
    private static final String[] IGNORED_METHODS = new String[]{"annotationType", "equals", "hashCode", "toString"};
    private final Set<ClassSignatureElement> elements = new HashSet<ClassSignatureElement>();

    public abstract String getValue() throws Exception;

    public void addSignatureElements(ClassSignatureElement[] elems) {
        for (ClassSignatureElement element : elems) {
            this.elements.add(element);
        }
    }

    public boolean hasElement(ClassSignatureElement element) {
        return this.elements.contains((Object)element);
    }

    protected String annotationToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        a = this.sort(a);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < a.length; ++i) {
            Annotation object = (Annotation)a[i];
            Method[] declaredMethods = object.getClass().getDeclaredMethods();
            b.append("(");
            boolean printComma = false;
            for (Method method : declaredMethods) {
                Object value;
                if (Arrays.binarySearch(IGNORED_METHODS, method.getName()) >= 0 || (value = this.getAnnotationValue(object, method.getName())) == null) continue;
                if (printComma) {
                    b.append(",");
                } else {
                    printComma = true;
                }
                if (value.getClass().isArray()) {
                    value = this.arrayToString(value);
                }
                b.append(method.getName() + "=" + value.getClass() + ":" + value);
            }
            b.append(")");
            b.append(object.annotationType().getName());
            if (i >= a.length - 1) continue;
            b.append(",");
        }
        b.append(']');
        return b.toString();
    }

    private Object arrayToString(Object value) {
        Object result = value;
        try {
            try {
                Method toStringMethod = Arrays.class.getMethod("toString", value.getClass());
                result = toStringMethod.invoke(null, value);
            }
            catch (NoSuchMethodException e) {
                if (value instanceof Object[]) {
                    Method toStringMethod = Arrays.class.getMethod("toString", Object[].class);
                    result = toStringMethod.invoke(null, value);
                }
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return result;
    }

    protected String annotationToString(Object[][] a) {
        if (a == null) {
            return "null";
        }
        int iMax = a.length - 1;
        if (iMax == -1) {
            return "[]";
        }
        a = this.sort(a);
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object[] object = a[i];
            b.append(this.annotationToString(object));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    private <T> T[] sort(T[] a) {
        a = Arrays.copyOf(a, a.length);
        Arrays.sort(a, ToStringComparator.INSTANCE);
        return a;
    }

    private <T> T[][] sort(T[][] a) {
        a = (Object[][])Arrays.copyOf(a, ((Object)a).length);
        Arrays.sort(a, ToStringComparator.INSTANCE);
        for (Object objects : a) {
            Arrays.sort(objects, ToStringComparator.INSTANCE);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getAnnotationValue(Annotation annotation, String attributeName) {
        Method method = null;
        boolean acessibleSet = false;
        try {
            method = annotation.annotationType().getDeclaredMethod(attributeName, new Class[0]);
            acessibleSet = this.makeAccessible(method);
            Object object = method.invoke((Object)annotation, new Object[0]);
            return object;
        }
        catch (Exception ex) {
            Object var6_7 = null;
            return var6_7;
        }
        finally {
            if (method != null && acessibleSet) {
                method.setAccessible(false);
            }
        }
    }

    private boolean makeAccessible(Method method) {
        if (!(Modifier.isPublic(method.getModifiers()) && Modifier.isPublic(method.getDeclaringClass().getModifiers()) || method.isAccessible())) {
            method.setAccessible(true);
            return true;
        }
        return false;
    }

    protected static class ToStringComparator
    implements Comparator<Object> {
        public static final ToStringComparator INSTANCE = new ToStringComparator();

        protected ToStringComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareTo(o2.toString());
        }
    }
}

