/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.versions.matcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import org.hotswap.agent.annotation.Manifest;
import org.hotswap.agent.annotation.Name;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.util.spring.util.PatternMatchUtils;
import org.hotswap.agent.util.spring.util.StringUtils;
import org.hotswap.agent.versions.ArtifactVersion;
import org.hotswap.agent.versions.DeploymentInfo;
import org.hotswap.agent.versions.InvalidVersionSpecificationException;
import org.hotswap.agent.versions.ManifestInfo;
import org.hotswap.agent.versions.VersionMatchResult;
import org.hotswap.agent.versions.VersionMatcher;
import org.hotswap.agent.versions.VersionRange;

public class ManifestMatcher
implements VersionMatcher {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ManifestMatcher.class);
    private final VersionRange includes;
    private final VersionRange excludes;
    private final Map<Attributes.Name, String> properties;
    private final String includesString;
    private final String excludesString;
    private final Attributes.Name[] version;

    public ManifestMatcher(Manifest cfg) throws InvalidVersionSpecificationException {
        if (StringUtils.hasText(cfg.value())) {
            this.includesString = cfg.value().trim();
            this.includes = VersionRange.createFromVersionSpec(this.includesString);
        } else {
            this.includes = null;
            this.includesString = null;
        }
        if (StringUtils.hasText(cfg.excludeVersion())) {
            this.excludesString = cfg.excludeVersion().trim();
            this.excludes = VersionRange.createFromVersionSpec(this.excludesString);
        } else {
            this.excludes = null;
            this.excludesString = null;
        }
        if (cfg.versionName() == null || cfg.versionName().length == 0) {
            this.version = null;
        } else {
            ArrayList<Attributes.Name> versions = new ArrayList<Attributes.Name>();
            String[] stringArray = cfg.versionName();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String versionName = stringArray[i];
                if (!StringUtils.hasText(versionName)) continue;
                versions.add(new Attributes.Name(versionName));
            }
            this.version = versions.toArray(new Attributes.Name[versions.size()]);
        }
        if (cfg.names() != null && cfg.names().length > 0) {
            this.properties = new HashMap<Attributes.Name, String>();
            for (Name name : cfg.names()) {
                if (!StringUtils.hasText(name.key()) || !StringUtils.hasText(name.value())) continue;
                this.properties.put(new Attributes.Name(name.key()), name.value());
            }
        } else {
            this.properties = Collections.emptyMap();
        }
    }

    public VersionRange getIncludes() {
        return this.includes;
    }

    public VersionRange getExcludes() {
        return this.excludes;
    }

    public Map<Attributes.Name, String> getProperties() {
        return this.properties;
    }

    @Override
    public VersionMatchResult matches(DeploymentInfo info) {
        if (info.getManifest() == null || info.getManifest().size() == 0) {
            return VersionMatchResult.SKIPPED;
        }
        for (ManifestInfo manifest : info.getManifest()) {
            VersionMatchResult result = this.match(manifest);
            if (VersionMatchResult.MATCHED.equals((Object)result)) {
                LOGGER.debug("Matched {} with {}", this, manifest);
                return VersionMatchResult.MATCHED;
            }
            if (!VersionMatchResult.REJECTED.equals((Object)result)) continue;
            LOGGER.debug("Rejected {} with {}", this, manifest);
            return VersionMatchResult.REJECTED;
        }
        return VersionMatchResult.SKIPPED;
    }

    private VersionMatchResult match(ManifestInfo manifest) {
        if (manifest == null) {
            return VersionMatchResult.SKIPPED;
        }
        String artifactVersion = manifest.getValue(this.version);
        if (StringUtils.isEmpty(artifactVersion)) {
            return VersionMatchResult.SKIPPED;
        }
        if (this.properties.size() == 0) {
            return VersionMatchResult.SKIPPED;
        }
        for (Map.Entry<Attributes.Name, String> e : this.properties.entrySet()) {
            String v = manifest.getValue(e.getKey());
            if (StringUtils.hasText(v) && PatternMatchUtils.regexMatch(e.getValue(), v)) continue;
            return VersionMatchResult.SKIPPED;
        }
        ArtifactVersion version = new ArtifactVersion(artifactVersion);
        if (this.excludes != null && this.excludes.containsVersion(version)) {
            return VersionMatchResult.REJECTED;
        }
        if (this.includes != null && !this.includes.containsVersion(version)) {
            return VersionMatchResult.REJECTED;
        }
        return VersionMatchResult.MATCHED;
    }

    public String toString() {
        return "ManifestMatcher [properties=" + this.properties + ", includes=" + this.includes + ", excludes=" + this.excludes + "]";
    }

    @Override
    public boolean isApply() {
        return (StringUtils.hasText(this.includesString) || StringUtils.hasText(this.excludesString)) && this.version != null;
    }
}

