/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import org.hotswap.agent.annotation.FileEvent;
import org.hotswap.agent.watch.WatchFileEvent;

public class HotswapWatchFileEvent
implements WatchFileEvent {
    private final WatchEvent<?> event;
    private final Path path;

    public HotswapWatchFileEvent(WatchEvent<?> event, Path path) {
        this.event = event;
        this.path = path;
    }

    @Override
    public FileEvent getEventType() {
        return HotswapWatchFileEvent.toAgentEvent(this.event.kind());
    }

    @Override
    public URI getURI() {
        return this.path.toUri();
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public boolean isDirectory() {
        return Files.isDirectory(this.path, new LinkOption[0]);
    }

    public String toString() {
        return "WatchFileEvent on path " + this.path + " for event " + this.event.kind();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotswapWatchFileEvent that = (HotswapWatchFileEvent)o;
        if (!this.event.equals(that.event)) {
            return false;
        }
        return this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.event.hashCode();
        result = 31 * result + this.path.hashCode();
        return result;
    }

    static FileEvent toAgentEvent(WatchEvent.Kind<?> kind) {
        if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
            return FileEvent.CREATE;
        }
        if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
            return FileEvent.MODIFY;
        }
        if (kind == StandardWatchEventKinds.ENTRY_DELETE) {
            return FileEvent.DELETE;
        }
        throw new IllegalArgumentException("Unknown event type " + kind.name());
    }
}

