/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import org.hotswap.agent.watch.nio.AbstractNIO2Watcher;
import org.hotswap.agent.watch.nio.PathPair;

public class TreeWatcherNIO
extends AbstractNIO2Watcher {
    private static final WatchEvent.Modifier HIGH = TreeWatcherNIO.getWatchEventModifier("com.sun.nio.file.SensitivityWatchEventModifier", "HIGH");
    private static final WatchEvent.Modifier FILE_TREE = TreeWatcherNIO.getWatchEventModifier("com.sun.nio.file.ExtendedWatchEventModifier", "FILE_TREE");
    private static final WatchEvent.Modifier[] MODIFIERS = FILE_TREE != null ? new WatchEvent.Modifier[]{FILE_TREE, HIGH} : new WatchEvent.Modifier[]{HIGH};

    private void register(Path watched, Path target) throws IOException {
        for (PathPair p : this.keys.values()) {
            if (!p.isWatching(target)) continue;
            this.LOGGER.debug("Path {} watched via {}", target, p.getWatched());
            return;
        }
        if (FILE_TREE == null) {
            this.LOGGER.debug("WATCHING:ENTRY_CREATE, ENTRY_DELETE, ENTRY_MODIFY - high} {}", watched);
        } else {
            this.LOGGER.debug("WATCHING: ENTRY_CREATE, ENTRY_DELETE, ENTRY_MODIFY - fileTree,high {}", watched);
        }
        WatchKey key = watched.register(this.watcher, KINDS, MODIFIERS);
        this.keys.put(key, new PathPair(target, watched));
    }

    @Override
    protected void registerAll(Path watched, Path target) throws IOException {
        if (watched == null) {
            watched = target;
        }
        this.LOGGER.info("Registering directory target {} via watched: {}", target, watched);
        this.register(watched, target);
    }
}

