/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.watch.nio;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.EnumSet;
import org.hotswap.agent.watch.nio.AbstractNIO2Watcher;
import org.hotswap.agent.watch.nio.PathPair;

public class WatcherNIO2
extends AbstractNIO2Watcher {
    private static final WatchEvent.Modifier HIGH = WatcherNIO2.getWatchEventModifier("com.sun.nio.file.SensitivityWatchEventModifier", "HIGH");

    @Override
    protected void registerAll(Path parent, Path start) throws IOException {
        if (parent != null) {
            this.LOGGER.debug("Registering directory  {} under parent {}", start, parent);
        } else {
            this.LOGGER.debug("Registering directory  {}", start);
        }
        Files.walkFileTree(start, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                WatcherNIO2.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void register(Path dir) throws IOException {
        WatchKey key = HIGH == null ? dir.register(this.watcher, KINDS) : dir.register(this.watcher, KINDS, HIGH);
        this.keys.put(key, PathPair.get(dir));
    }
}

