/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db;

import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.Resource;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.annotations.Widget;
import com.axelor.team.db.TeamTask;
import com.google.common.base.MoreObjects;
import java.time.LocalDateTime;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="PROJECT_RESOURCE_BOOKING", indexes={@Index(columnList="name"), @Index(columnList="project_resource"), @Index(columnList="project"), @Index(columnList="task"), @Index(columnList="user_id")})
public class ResourceBooking
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PROJECT_RESOURCE_BOOKING_SEQ")
    @SequenceGenerator(name="PROJECT_RESOURCE_BOOKING_SEQ", sequenceName="PROJECT_RESOURCE_BOOKING_SEQ", allocationSize=1)
    private Long id;
    private String name;
    @Widget(title="Resource")
    @NotNull
    @JoinColumn(name="project_resource")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Resource resource;
    @Widget(title="Project")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Project project;
    @Widget(title="Task")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TeamTask task;
    @Widget(title="Update period according to task")
    private Boolean updateTaskFromPeriod = Boolean.FALSE;
    @JoinColumn(name="user_id")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private User user;
    @Widget(title="From date")
    private LocalDateTime fromDate;
    @Widget(title="To date")
    private LocalDateTime toDate;
    @Widget(title="Notes")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String notes;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public ResourceBooking() {
    }

    public ResourceBooking(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Resource getResource() {
        return this.resource;
    }

    public void setResource(Resource resource) {
        this.resource = resource;
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public TeamTask getTask() {
        return this.task;
    }

    public void setTask(TeamTask task) {
        this.task = task;
    }

    public Boolean getUpdateTaskFromPeriod() {
        return this.updateTaskFromPeriod == null ? Boolean.FALSE : this.updateTaskFromPeriod;
    }

    public void setUpdateTaskFromPeriod(Boolean updateTaskFromPeriod) {
        this.updateTaskFromPeriod = updateTaskFromPeriod;
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ResourceBooking)) {
            return false;
        }
        ResourceBooking other = (ResourceBooking)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("updateTaskFromPeriod", (Object)this.getUpdateTaskFromPeriod()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).omitNullValues().toString();
    }
}

