/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db.repo;

import com.axelor.apps.base.db.AppProject;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.project.service.app.AppProjectService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.team.db.Team;
import com.google.common.base.Strings;
import java.math.BigDecimal;
import javax.persistence.PersistenceException;

public class ProjectManagementRepository
extends ProjectRepository {
    private void setAllProjectFullName(Project project) {
        String projectCode = Strings.isNullOrEmpty((String)project.getCode()) ? "" : project.getCode() + " - ";
        project.setFullName(projectCode + project.getName());
        if (project.getChildProjectList() != null && !project.getChildProjectList().isEmpty()) {
            for (Project child : project.getChildProjectList()) {
                String code = Strings.isNullOrEmpty((String)child.getCode()) ? "" : child.getCode() + " - ";
                child.setFullName(code + child.getName());
            }
        }
    }

    public static void setAllProjectMembersUserSet(Project project) {
        if (project.getParentProject() == null && project.getChildProjectList() != null) {
            project.getChildProjectList().stream().filter(Project::getExtendsMembersFromParent).peek(p -> project.getMembersUserSet().forEach(p::addMembersUserSetItem)).forEach(p -> p.setTeam(project.getTeam()));
        } else if (project.getParentProject() != null && project.getExtendsMembersFromParent().booleanValue() && !project.getSynchronize().booleanValue()) {
            project.getParentProject().getMembersUserSet().forEach(project.getMembersUserSet()::add);
        }
    }

    public Project save(Project project) {
        Team team;
        ProjectManagementRepository.setAllProjectMembersUserSet(project);
        if (project.getSynchronize().booleanValue() && (team = project.getTeam()) != null) {
            team.clearMembers();
            project.getMembersUserSet().forEach(team::addMember);
        }
        try {
            AppProject appProject = ((AppProjectService)Beans.get(AppProjectService.class)).getAppProject();
            if (Strings.isNullOrEmpty((String)project.getCode()) && appProject.getGenerateProjectSequence().booleanValue()) {
                Company company = project.getCompany();
                String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("project", company);
                if (seq == null) {
                    throw new AxelorException((Model)company, 4, I18n.get((String)"The company %s doesn't have any configured sequence for Project"), new Object[]{company.getName()});
                }
                project.setCode(seq);
            }
        }
        catch (AxelorException e) {
            throw new PersistenceException(e.getLocalizedMessage());
        }
        this.setAllProjectFullName(project);
        project.setEstimatedTimeHrs(project.getEstimatedTimeDays().multiply(((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getDailyWorkHours()));
        return (Project)((Object)super.save((Model)((Object)project)));
    }

    public Project copy(Project entity, boolean deep) {
        Project project = (Project)((Object)super.copy((Model)((Object)entity), false));
        project.setStatusSelect(STATE_NEW);
        project.setProgress(BigDecimal.ZERO);
        return project;
    }
}

