/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.db.repo;

import com.axelor.apps.base.db.repo.TeamTaskBaseRepository;
import com.axelor.team.db.TeamTask;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TeamTaskProjectRepository
extends TeamTaskBaseRepository {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public TeamTask save(TeamTask teamTask) {
        ArrayList<String> composedNames = new ArrayList<String>();
        if (teamTask.getId() != null) {
            composedNames.add("#" + teamTask.getId());
        }
        composedNames.add(teamTask.getName());
        teamTask.setFullName(String.join((CharSequence)" ", composedNames));
        return super.save(teamTask);
    }

    public Map<String, Object> validate(Map<String, Object> json, Map<String, Object> context) {
        this.logger.debug("Validate team task:{}", json);
        this.logger.debug("Planned progress:{}, ProgressSelect: {}, DurationHours: {}, TaskDuration: {}", new Object[]{json.get("plannedProgress"), json.get("progressSelect"), json.get("durationHours"), json.get("taskDuration")});
        if (json.get("id") != null) {
            TeamTask savedTask = (TeamTask)((Object)this.find(Long.parseLong(json.get("id").toString())));
            if (json.get("plannedProgress") != null) {
                BigDecimal plannedProgress = new BigDecimal(json.get("plannedProgress").toString());
                if (plannedProgress != null && savedTask.getPlannedProgress().intValue() != plannedProgress.intValue()) {
                    this.logger.debug("Updating progressSelect: {}", (Object)((int)((double)plannedProgress.intValue() * 0.1) * 10));
                    json.put("progressSelect", (int)((double)plannedProgress.intValue() * 0.1) * 10);
                }
            } else if (json.get("progressSelect") != null) {
                Integer progressSelect = new Integer(json.get("progressSelect").toString());
                this.logger.debug("Updating plannedProgress: {}", (Object)progressSelect);
                json.put("plannedProgress", new BigDecimal(progressSelect));
            }
            if (json.get("durationHours") != null) {
                BigDecimal durationHours = new BigDecimal(json.get("durationHours").toString());
                if (durationHours != null && savedTask.getDurationHours().intValue() != durationHours.intValue()) {
                    this.logger.debug("Updating taskDuration: {}", (Object)durationHours.divide(new BigDecimal(24), RoundingMode.HALF_EVEN).intValue());
                    json.put("taskDuration", durationHours.multiply(new BigDecimal(3600)).intValue());
                }
            } else if (json.get("taskDuration") != null) {
                Integer taskDuration = new Integer(json.get("taskDuration").toString());
                this.logger.debug("Updating durationHours: {}", (Object)(taskDuration / 3600));
                json.put("durationHours", new BigDecimal(taskDuration / 3600));
            }
        } else {
            if (json.get("progressSelect") != null) {
                Integer progressSelect = new Integer(json.get("progressSelect").toString());
                json.put("plannedProgress", new BigDecimal(progressSelect));
            }
            if (json.get("taskDuration") != null) {
                Integer taskDuration = new Integer(json.get("taskDuration").toString());
                json.put("durationHours", new BigDecimal(taskDuration / 3600));
            }
        }
        return super.validate(json, context);
    }

    public TeamTask copy(TeamTask entity, boolean deep) {
        TeamTask task = super.copy(entity, deep);
        task.setProgressSelect(null);
        task.setTaskEndDate(null);
        task.setMetaFile(null);
        return task;
    }
}

