/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectFolder;
import com.axelor.apps.project.db.ProjectTemplate;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.TeamTaskCategory;
import com.axelor.apps.project.db.Wiki;
import com.axelor.apps.project.db.repo.ProjectRepository;
import com.axelor.apps.project.db.repo.WikiRepository;
import com.axelor.apps.project.service.ProjectService;
import com.axelor.apps.project.service.TeamTaskProjectService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.ObjectUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.team.db.TeamTask;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ProjectServiceImpl
implements ProjectService {
    public static final int MAX_LEVEL_OF_PROJECT = 10;
    private ProjectRepository projectRepository;
    @Inject
    WikiRepository wikiRepo;
    @Inject
    TeamTaskProjectService teamTaskProjectService;

    @Inject
    public ProjectServiceImpl(ProjectRepository projectRepository) {
        this.projectRepository = projectRepository;
    }

    @Override
    public Project generateProject(Project parentProject, String fullName, User assignedTo, Company company, Partner clientPartner) {
        Project project = this.projectRepository.findByName(fullName);
        if (project != null) {
            return project;
        }
        project = new Project();
        project.setStatusSelect(ProjectRepository.STATE_NEW);
        project.setParentProject(parentProject);
        if (parentProject != null) {
            parentProject.addChildProjectListItem(project);
            project.setProjectTypeSelect(ProjectRepository.TYPE_PHASE);
        } else {
            project.setProjectTypeSelect(ProjectRepository.TYPE_PROJECT);
        }
        if (Strings.isNullOrEmpty((String)fullName)) {
            fullName = "project";
        }
        project.setName(fullName);
        project.setFullName(project.getName());
        project.setCompany(company);
        project.setClientPartner(clientPartner);
        project.setAssignedTo(assignedTo);
        project.setProgress(BigDecimal.ZERO);
        return project;
    }

    @Override
    @Transactional
    public Project generateProject(Partner partner) {
        Preconditions.checkNotNull((Object)partner);
        User user = AuthUtils.getUser();
        Project project = ((ProjectService)Beans.get(ProjectService.class)).generateProject(null, this.getUniqueProjectName(partner), user, user.getActiveCompany(), partner);
        return (Project)((Object)this.projectRepository.save((Model)((Object)project)));
    }

    private String getUniqueProjectName(Partner partner) {
        String name;
        String baseName = String.format(I18n.get((String)"%s project"), partner.getName());
        long count = this.projectRepository.all().filter(String.format("self.name LIKE '%s%%'", baseName)).count();
        if (count == 0L) {
            return baseName;
        }
        while (this.projectRepository.findByName(name = String.format("%s %d", baseName, ++count)) != null) {
        }
        return name;
    }

    @Override
    @Transactional
    public Project createProjectFromTemplate(ProjectTemplate projectTemplate, String projectCode, Partner clientPartner) throws AxelorException {
        Project project = new Project();
        project.setName(projectTemplate.getName());
        if (this.projectRepository.all().filter("self.code = ?", new Object[]{projectCode}).count() > 0L) {
            throw new AxelorException(5, "Project code is already used. Please provide unique code");
        }
        project.setCode(projectCode);
        project.setClientPartner(clientPartner);
        if (clientPartner != null && clientPartner.getContactPartnerSet() != null && !clientPartner.getContactPartnerSet().isEmpty()) {
            project.setContactPartner((Partner)clientPartner.getContactPartnerSet().iterator().next());
        }
        project.setDescription(projectTemplate.getDescription());
        project.setTeam(projectTemplate.getTeam());
        project.setProjectFolderSet(new HashSet<ProjectFolder>(projectTemplate.getProjectFolderSet()));
        project.setAssignedTo(projectTemplate.getAssignedTo());
        project.setTeamTaskCategorySet(new HashSet<TeamTaskCategory>(projectTemplate.getTeamTaskCategorySet()));
        project.setSynchronize(projectTemplate.getSynchronize());
        project.setMembersUserSet(new HashSet<User>(projectTemplate.getMembersUserSet()));
        project.setImputable(projectTemplate.getImputable());
        project.setCompany(projectTemplate.getCompany());
        project.setProductSet(new HashSet<Product>(projectTemplate.getProductSet()));
        project.setExcludePlanning(projectTemplate.getExcludePlanning());
        project.setProjectTypeSelect(ProjectRepository.TYPE_PROJECT);
        List<Wiki> wikiList = projectTemplate.getWikiList();
        if (wikiList != null && !wikiList.isEmpty()) {
            for (Wiki wiki : wikiList) {
                wiki = (Wiki)((Object)this.wikiRepo.copy((Model)((Object)wiki), false));
                wiki.setProjectTemplate(null);
                project.addWikiListItem(wiki);
            }
        }
        this.projectRepository.save((Model)((Object)project));
        Set<TaskTemplate> taskTemplateSet = projectTemplate.getTaskTemplateSet();
        ArrayList<TaskTemplate> taskTemplateList = new ArrayList<TaskTemplate>(taskTemplateSet);
        Collections.sort(taskTemplateList, new Comparator<TaskTemplate>(){

            @Override
            public int compare(TaskTemplate taskTemplatet1, TaskTemplate taskTemplate2) {
                return taskTemplatet1.getParentTaskTemplate() == null || taskTemplate2 == null ? 1 : (taskTemplatet1.getParentTaskTemplate().equals((Object)taskTemplate2) ? -1 : 1);
            }
        });
        if (taskTemplateList != null) {
            for (TaskTemplate taskTemplate : taskTemplateList) {
                this.createTask(taskTemplate, project, taskTemplateSet);
            }
        }
        return project;
    }

    public TeamTask createTask(TaskTemplate taskTemplate, Project project, Set<TaskTemplate> taskTemplateSet) {
        TaskTemplate parentTaskTemplate;
        if (!ObjectUtils.isEmpty(project.getTeamTaskList())) {
            for (TeamTask teamTask : project.getTeamTaskList()) {
                if (!teamTask.getName().equals(taskTemplate.getName())) continue;
                return teamTask;
            }
        }
        TeamTask task = this.teamTaskProjectService.create(taskTemplate.getName(), project, taskTemplate.getAssignedTo());
        task.setDescription(taskTemplate.getDescription());
        TeamTaskCategory teamTaskCategory = taskTemplate.getTeamTaskCategory();
        if (teamTaskCategory != null) {
            task.setTeamTaskCategory(teamTaskCategory);
            project.addTeamTaskCategorySetItem(teamTaskCategory);
        }
        if ((parentTaskTemplate = taskTemplate.getParentTaskTemplate()) != null && taskTemplateSet.contains((Object)parentTaskTemplate)) {
            task.setParentTask(this.createTask(parentTaskTemplate, project, taskTemplateSet));
            return task;
        }
        return task;
    }
}

