/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.project.db.ProjectTemplate;
import com.axelor.apps.project.db.TaskTemplate;
import com.axelor.apps.project.db.repo.ProjectTemplateRepository;
import com.axelor.apps.project.service.ProjectTemplateService;
import com.axelor.apps.project.service.TaskTemplateService;
import com.axelor.common.ObjectUtils;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Set;

public class ProjectTemplateServiceImpl
implements ProjectTemplateService {
    protected ProjectTemplateRepository projectTemplateRepo;
    protected TaskTemplateService taskTemplateService;

    @Inject
    public ProjectTemplateServiceImpl(ProjectTemplateRepository projectTemplateRepo, TaskTemplateService taskTemplateService) {
        this.projectTemplateRepo = projectTemplateRepo;
        this.taskTemplateService = taskTemplateService;
    }

    @Override
    public ProjectTemplate addParentTaskTemplate(ProjectTemplate projectTemplate) {
        Set<TaskTemplate> oldTaskTemplateSet;
        Set<TaskTemplate> taskTemplateSet = projectTemplate.getTaskTemplateSet();
        if (ObjectUtils.isEmpty(taskTemplateSet)) {
            return projectTemplate;
        }
        if (projectTemplate.getId() != null && !ObjectUtils.isEmpty(oldTaskTemplateSet = ((ProjectTemplate)((Object)this.projectTemplateRepo.find(projectTemplate.getId()))).getTaskTemplateSet()) && oldTaskTemplateSet.size() > taskTemplateSet.size()) {
            return projectTemplate;
        }
        for (TaskTemplate taskTemplate : new HashSet<TaskTemplate>(taskTemplateSet)) {
            taskTemplateSet.addAll(this.taskTemplateService.getParentTaskTemplateFromTaskTemplate(taskTemplate.getParentTaskTemplate(), taskTemplateSet));
        }
        return projectTemplate;
    }
}

