/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.service;

import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.db.TimerHistory;
import com.axelor.apps.base.db.repo.TimerHistoryRepository;
import com.axelor.apps.base.db.repo.TimerRepository;
import com.axelor.apps.base.service.timer.AbstractTimerService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.project.service.TimerTeamTaskService;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.team.db.TeamTask;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.Duration;
import java.time.LocalDateTime;

public class TimerTeamTaskServiceImpl
extends AbstractTimerService
implements TimerTeamTaskService {
    @Inject
    public TimerTeamTaskServiceImpl(TimerRepository timerRepository, TimerHistoryRepository timerHistoryRepository, UserService userService) {
        super(timerRepository, timerHistoryRepository, userService);
    }

    public Timer find(Model model) {
        User user = this.userService.getUser();
        TeamTask task = (TeamTask)((Object)model);
        return task.getTimerList().stream().filter(t -> t.getAssignedToUser() == user).findFirst().orElse(null);
    }

    @Transactional(rollbackOn={Exception.class})
    public TimerHistory start(Model model, Timer timer, LocalDateTime dateTime) throws AxelorException {
        TeamTask task = (TeamTask)((Object)model);
        boolean isNewTimer = timer == null;
        timer = this.tryStartOrCreate(timer);
        if (isNewTimer) {
            task.addTimerListItem(timer);
        }
        TimerHistory history = new TimerHistory();
        history.setStartDateT(dateTime);
        history.setTimer(timer);
        timer.addTimerHistoryListItem(history);
        return (TimerHistory)this.timerHistoryRepository.save((Model)history);
    }

    @Override
    public Timer find(TeamTask task) {
        return this.find((Model)((Object)task));
    }

    @Override
    public TimerHistory start(TeamTask task, LocalDateTime dateTime) throws AxelorException {
        Timer timer = this.find(task);
        return this.start((Model)((Object)task), timer, dateTime);
    }

    @Override
    public TimerHistory stop(TeamTask task, LocalDateTime dateTime) throws AxelorException {
        Timer timer = this.find(task);
        return this.stop((Model)((Object)task), timer, dateTime);
    }

    @Override
    public void cancel(TeamTask task) {
        Timer timer = this.find(task);
        this.cancel(timer);
    }

    @Override
    public Duration compute(TeamTask task) {
        Duration total = Duration.ZERO;
        for (Timer timer : task.getTimerList()) {
            total = total.plus(this.compute(timer));
        }
        return total;
    }
}

