/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.web;

import com.axelor.apps.base.db.AppProject;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.project.db.Project;
import com.axelor.apps.project.db.ProjectTemplate;
import com.axelor.apps.project.db.repo.ProjectTemplateRepository;
import com.axelor.apps.project.service.ProjectService;
import com.axelor.apps.project.service.ProjectTemplateService;
import com.axelor.apps.project.service.app.AppProjectService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.util.LinkedHashMap;

@Singleton
public class ProjectTemplateController {
    public void createProjectFromTemplate(ActionRequest request, ActionResponse response) {
        ProjectTemplate projectTemplate = (ProjectTemplate)((Object)request.getContext().asType(ProjectTemplate.class));
        AppProject appProject = ((AppProjectService)Beans.get(AppProjectService.class)).getAppProject();
        if (appProject.getGenerateProjectSequence().booleanValue() && !projectTemplate.getIsBusinessProject().booleanValue()) {
            try {
                projectTemplate = (ProjectTemplate)((Object)((ProjectTemplateRepository)((Object)Beans.get(ProjectTemplateRepository.class))).find(projectTemplate.getId()));
                Project project = ((ProjectService)Beans.get(ProjectService.class)).createProjectFromTemplate(projectTemplate, null, null);
                response.setView(ActionView.define((String)I18n.get((String)"Project")).model(Project.class.getName()).add("form", "project-form").add("grid", "project-grid").param("search-filters", "project-filters").context("_showRecord", (Object)project.getId()).map());
            }
            catch (AxelorException e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Create project from this template")).model(Wizard.class.getName()).add("form", "project-template-wizard-form").param("popup", "reload").param("show-toolbar", "false").param("show-confirm", "false").param("width", "large").param("popup-save", "false").context("_projectTemplate", (Object)projectTemplate).context("_businessProject", (Object)projectTemplate.getIsBusinessProject()).map());
        }
    }

    public void createProjectFromWizard(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        String projectTemplateId = ((LinkedHashMap)context.get((Object)"_projectTemplate")).get("id").toString();
        ProjectTemplate projectTemplate = (ProjectTemplate)((Object)((ProjectTemplateRepository)((Object)Beans.get(ProjectTemplateRepository.class))).find(Long.parseLong(projectTemplateId)));
        String projectCode = (String)context.get((Object)"code");
        Object clientPartnerContext = context.get((Object)"clientPartner");
        Partner clientPartner = null;
        if (clientPartnerContext != null) {
            String clientPartnerId = ((LinkedHashMap)clientPartnerContext).get("id").toString();
            clientPartner = (Partner)((PartnerRepository)Beans.get(PartnerRepository.class)).find(Long.valueOf(Long.parseLong(clientPartnerId)));
        }
        try {
            Project project = ((ProjectService)Beans.get(ProjectService.class)).createProjectFromTemplate(projectTemplate, projectCode, clientPartner);
            response.setCanClose(true);
            response.setView(ActionView.define((String)I18n.get((String)"Project")).model(Project.class.getName()).add("form", "project-form").add("grid", "project-grid").param("search-filters", "project-filters").context("_showRecord", (Object)project.getId()).map());
        }
        catch (AxelorException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void addParentTaskTemplate(ActionRequest request, ActionResponse response) {
        ProjectTemplate projectTemplate = (ProjectTemplate)((Object)request.getContext().asType(ProjectTemplate.class));
        projectTemplate = ((ProjectTemplateService)Beans.get(ProjectTemplateService.class)).addParentTaskTemplate(projectTemplate);
        response.setValue("taskTemplateSet", projectTemplate.getTaskTemplateSet());
    }
}

