/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.project.web;

import com.axelor.apps.base.db.Timer;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.project.service.TeamTaskProjectService;
import com.axelor.apps.project.service.TimerTeamTaskService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.team.db.TeamTask;
import com.axelor.team.db.repo.TeamTaskRepository;
import java.time.Duration;

public class TeamTaskController {
    private static final String HIDDEN_ATTR = "hidden";

    public void manageTimerButtons(ActionRequest request, ActionResponse response) {
        try {
            TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            TimerTeamTaskService service = (TimerTeamTaskService)Beans.get(TimerTeamTaskService.class);
            if (task.getId() == null) {
                return;
            }
            Timer timer = service.find(task);
            boolean hideStart = false;
            boolean hideCancel = true;
            if (timer != null) {
                hideStart = timer.getStatusSelect() == 1;
                hideCancel = timer.getTimerHistoryList().isEmpty();
            }
            response.setAttr("startTimerBtn", HIDDEN_ATTR, (Object)hideStart);
            response.setAttr("stopTimerBtn", HIDDEN_ATTR, (Object)(!hideStart ? 1 : 0));
            response.setAttr("cancelTimerBtn", HIDDEN_ATTR, (Object)hideCancel);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void computeTotalTimerDuration(ActionRequest request, ActionResponse response) {
        try {
            TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            if (task.getId() == null) {
                return;
            }
            Duration duration = ((TimerTeamTaskService)Beans.get(TimerTeamTaskService.class)).compute(task);
            response.setValue("$_totalTimerDuration", (Object)Float.valueOf((float)duration.toMinutes() / 60.0f));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void startTimer(ActionRequest request, ActionResponse response) {
        try {
            TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            ((TimerTeamTaskService)Beans.get(TimerTeamTaskService.class)).start(task, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void stopTimer(ActionRequest request, ActionResponse response) {
        try {
            TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            ((TimerTeamTaskService)Beans.get(TimerTeamTaskService.class)).stop(task, ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime());
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancelTimer(ActionRequest request, ActionResponse response) {
        try {
            TeamTask task = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            ((TimerTeamTaskService)Beans.get(TimerTeamTaskService.class)).cancel(task);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void deleteTeamTask(ActionRequest request, ActionResponse response) {
        try {
            TeamTask teamTask = (TeamTask)((Object)request.getContext().asType(TeamTask.class));
            teamTask = (TeamTask)((Object)((TeamTaskRepository)((Object)Beans.get(TeamTaskRepository.class))).find(teamTask.getId()));
            ((TeamTaskProjectService)Beans.get(TeamTaskProjectService.class)).deleteTeamTask(teamTask);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

