/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.hotswap.agent.command.Command;
import org.hotswap.agent.command.MergeableCommand;
import org.hotswap.agent.config.PluginManager;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.ProxyClassSignatureHelper;
import org.hotswap.agent.plugin.proxy.ProxyPlugin;
import org.hotswap.agent.plugin.proxy.java.ProxyGenerator;

public class ReloadJavaProxyCommand
extends MergeableCommand {
    private static AgentLogger LOGGER = AgentLogger.getLogger(ReloadJavaProxyCommand.class);
    private ClassLoader classLoader;
    private String className;
    private Map<String, String> signatureMapOrig;

    public ReloadJavaProxyCommand(ClassLoader classLoader, String className, Map<String, String> signatureMapOrig) {
        this.classLoader = classLoader;
        this.classLoader = classLoader;
        this.className = className;
        this.className = className;
        this.signatureMapOrig = signatureMapOrig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand() {
        try {
            this.executeSingleCommand();
            ArrayList commands = new ArrayList(this.getMergedCommands());
            for (Command command : commands) {
                ((ReloadJavaProxyCommand)command).executeSingleCommand();
            }
        }
        finally {
            ProxyPlugin.reloadFlag = false;
        }
    }

    public void executeSingleCommand() {
        try {
            Class<?> clazz = this.classLoader.loadClass(this.className);
            Map<String, String> signatureMap = ProxyClassSignatureHelper.getNonSyntheticSignatureMap(clazz);
            if (!signatureMap.equals(this.signatureMapOrig)) {
                byte[] generateProxyClass = ProxyGenerator.generateProxyClass(this.className, clazz.getInterfaces());
                HashMap reloadMap = new HashMap();
                reloadMap.put(clazz, generateProxyClass);
                PluginManager.getInstance().hotswap(reloadMap);
                LOGGER.reload("Class '{}' has been reloaded.", new Object[]{this.className});
            }
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("Error redefining java proxy {}", (Throwable)e, new Object[]{this.className});
        }
    }

    public boolean shiftScheduleTime() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ReloadJavaProxyCommand that = (ReloadJavaProxyCommand)((Object)o);
        return this.classLoader.equals(that.classLoader);
    }

    public int hashCode() {
        int result = this.classLoader.hashCode();
        return result;
    }

    public String toString() {
        return "ReloadJavaProxyCommand{classLoader=" + this.classLoader + '}';
    }
}

