/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.hscglib;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.hotswap.agent.javassist.CtClass;
import org.hotswap.agent.javassist.CtMethod;
import org.hotswap.agent.javassist.Modifier;
import org.hotswap.agent.javassist.bytecode.MethodInfo;
import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.hscglib.GeneratorParametersRecorder;
import org.hotswap.agent.plugin.proxy.hscglib.GeneratorParams;

public class GeneratorParametersTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(GeneratorParametersTransformer.class);
    private static Map<ClassLoader, WeakReference<Map<String, Object>>> classLoaderMaps = new WeakHashMap<ClassLoader, WeakReference<Map<String, Object>>>();

    public static CtClass transform(CtClass cc) throws Exception {
        if (GeneratorParametersTransformer.isGeneratorStrategy(cc)) {
            for (CtMethod method : cc.getDeclaredMethods()) {
                if (Modifier.isAbstract((int)method.getModifiers()) || !method.getName().equals("generate") || !method.getMethodInfo().getDescriptor().endsWith(";)[B")) continue;
                cc.defrost();
                method.insertAfter("org.hotswap.agent.plugin.proxy.hscglib.GeneratorParametersRecorder.register($0, $1, $_);");
            }
        }
        return cc;
    }

    private static boolean isGeneratorStrategy(CtClass cc) {
        String[] interfaces;
        for (String interfaceName : interfaces = cc.getClassFile2().getInterfaces()) {
            if (!interfaceName.endsWith(".GeneratorStrategy")) continue;
            List methodInfos = cc.getClassFile2().getMethods();
            for (MethodInfo method : methodInfos) {
                if (!method.getName().equals("generate") || !method.getDescriptor().endsWith("[B")) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> getGeneratorParamsMap(ClassLoader loader) {
        try {
            WeakReference<Map<String, Object>> mapRef;
            Map<ClassLoader, WeakReference<Map<String, Object>>> map = classLoaderMaps;
            synchronized (map) {
                mapRef = classLoaderMaps.get(loader);
                if (mapRef == null) {
                    Map map2 = (Map)loader.loadClass(GeneratorParametersRecorder.class.getName()).getField("generatorParams").get(null);
                    mapRef = new WeakReference<Map>(map2);
                    classLoaderMaps.put(loader, mapRef);
                }
            }
            Map map3 = (Map)mapRef.get();
            if (map3 == null) {
                return new HashMap<String, Object>();
            }
            return map3;
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
            LOGGER.error("Unable to access field with proxy generation parameters. Proxy redefinition failed.", new Object[0]);
            throw new RuntimeException(e);
        }
    }

    public static GeneratorParams getGeneratorParams(ClassLoader loader, String name) {
        Object generatorParams = GeneratorParametersTransformer.getGeneratorParamsMap(loader).get(name);
        if (generatorParams != null) {
            try {
                return GeneratorParams.valueOf(generatorParams);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

