/*
 * Decompiled with CFR 0.152.
 */
package org.hotswap.agent.plugin.proxy.java;

import org.hotswap.agent.logging.AgentLogger;
import org.hotswap.agent.plugin.proxy.ParentLastClassLoader;
import org.hotswap.agent.plugin.proxy.ProxyClassSignatureHelper;
import org.hotswap.agent.plugin.proxy.ProxyTransformer;
import org.hotswap.agent.plugin.proxy.java.ProxyGenerator;

public class NewClassLoaderJavaProxyTransformer
implements ProxyTransformer {
    private static AgentLogger LOGGER = AgentLogger.getLogger(NewClassLoaderJavaProxyTransformer.class);
    private final Class<?> classBeingRedefined;
    private final byte[] classfileBuffer;
    private final ClassLoader loader;

    public NewClassLoaderJavaProxyTransformer(Class<?> classBeingRedefined, byte[] classfileBuffer, ClassLoader loader) {
        this.classBeingRedefined = classBeingRedefined;
        this.classfileBuffer = classfileBuffer;
        this.loader = loader;
    }

    public static byte[] transform(Class<?> classBeingRedefined, byte[] classfileBuffer, ClassLoader loader) throws Exception {
        return new NewClassLoaderJavaProxyTransformer(classBeingRedefined, classfileBuffer, loader).transformRedefine();
    }

    @Override
    public byte[] transformRedefine() throws Exception {
        try {
            ParentLastClassLoader parentLastClassLoader = new ParentLastClassLoader(this.loader);
            Class<?>[] interfaces = this.classBeingRedefined.getInterfaces();
            Class[] newInterfaces = new Class[interfaces.length];
            for (int i = 0; i < newInterfaces.length; ++i) {
                newInterfaces[i] = parentLastClassLoader.loadClass(interfaces[i].getName());
            }
            if (!ProxyClassSignatureHelper.isDifferent(interfaces, newInterfaces)) {
                return this.classfileBuffer;
            }
            Class<?> generatorClass = parentLastClassLoader.loadClass(ProxyGenerator.class.getName());
            byte[] generateProxyClass = (byte[])generatorClass.getDeclaredMethod("generateProxyClass", String.class, Class[].class).invoke(null, this.classBeingRedefined.getName(), newInterfaces);
            LOGGER.reload("Class '{}' has been reloaded.", new Object[]{this.classBeingRedefined.getName()});
            return generateProxyClass;
        }
        catch (Exception e) {
            LOGGER.error("Error transforming a Java reflect Proxy", (Throwable)e, new Object[0]);
            return this.classfileBuffer;
        }
    }
}

