/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.account.db;

import com.axelor.apps.account.db.Account;
import com.axelor.apps.account.db.AccountType;
import com.axelor.apps.account.db.AnalyticAccount;
import com.axelor.apps.account.db.AnalyticAxis;
import com.axelor.apps.account.db.AnalyticDistributionTemplate;
import com.axelor.apps.account.db.AnalyticJournal;
import com.axelor.apps.account.db.InvoiceLine;
import com.axelor.apps.account.db.MoveLine;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.hr.db.ExpenseLine;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Table(name="ACCOUNT_ANALYTIC_MOVE_LINE", indexes={@Index(name="idx_acc_ana_move_line_ana_dist_template", columnList="analytic_distribution_template"), @Index(columnList="invoice_line"), @Index(columnList="move_line"), @Index(columnList="analytic_axis"), @Index(columnList="analytic_account"), @Index(columnList="analytic_journal"), @Index(columnList="account"), @Index(columnList="account_type"), @Index(columnList="currency"), @Index(columnList="expense_line")})
@Track(fields={@TrackField(name="date", on={TrackEvent.UPDATE}), @TrackField(name="analyticAccount", on={TrackEvent.UPDATE}), @TrackField(name="analyticJournal", on={TrackEvent.UPDATE}), @TrackField(name="invoiceLine", on={TrackEvent.UPDATE}), @TrackField(name="moveLine", on={TrackEvent.UPDATE})})
public class AnalyticMoveLine
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="ACCOUNT_ANALYTIC_MOVE_LINE_SEQ")
    @SequenceGenerator(name="ACCOUNT_ANALYTIC_MOVE_LINE_SEQ", sequenceName="ACCOUNT_ANALYTIC_MOVE_LINE_SEQ", allocationSize=1)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticDistributionTemplate analyticDistributionTemplate;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private InvoiceLine invoiceLine;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MoveLine moveLine;
    @Widget(title="Axis")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAxis analyticAxis;
    @Widget(title="Analytic Acc.")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticAccount analyticAccount;
    @Widget(title="%")
    private BigDecimal percentage = BigDecimal.ZERO;
    @Widget(title="Original piece amount", hidden=true)
    private BigDecimal originalPieceAmount = BigDecimal.ZERO;
    @Widget(title="Amount")
    private BigDecimal amount = BigDecimal.ZERO;
    @Widget(title="Date")
    @NotNull
    @Column(name="date_val")
    private LocalDate date;
    @Widget(title="Analytic Journal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AnalyticJournal analyticJournal;
    @Widget(title="Accounting.Account")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Account account;
    @Widget(title="Account Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AccountType accountType;
    @Widget(title="Type", selection="account.analytic.move.line.type.select")
    private Integer typeSelect = 1;
    @Widget(title="Currency")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Currency currency;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private ExpenseLine expenseLine;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public AnalyticDistributionTemplate getAnalyticDistributionTemplate() {
        return this.analyticDistributionTemplate;
    }

    public void setAnalyticDistributionTemplate(AnalyticDistributionTemplate analyticDistributionTemplate) {
        this.analyticDistributionTemplate = analyticDistributionTemplate;
    }

    public InvoiceLine getInvoiceLine() {
        return this.invoiceLine;
    }

    public void setInvoiceLine(InvoiceLine invoiceLine) {
        this.invoiceLine = invoiceLine;
    }

    public MoveLine getMoveLine() {
        return this.moveLine;
    }

    public void setMoveLine(MoveLine moveLine) {
        this.moveLine = moveLine;
    }

    public AnalyticAxis getAnalyticAxis() {
        return this.analyticAxis;
    }

    public void setAnalyticAxis(AnalyticAxis analyticAxis) {
        this.analyticAxis = analyticAxis;
    }

    public AnalyticAccount getAnalyticAccount() {
        return this.analyticAccount;
    }

    public void setAnalyticAccount(AnalyticAccount analyticAccount) {
        this.analyticAccount = analyticAccount;
    }

    public BigDecimal getPercentage() {
        return this.percentage == null ? BigDecimal.ZERO : this.percentage;
    }

    public void setPercentage(BigDecimal percentage) {
        this.percentage = percentage;
    }

    public BigDecimal getOriginalPieceAmount() {
        return this.originalPieceAmount == null ? BigDecimal.ZERO : this.originalPieceAmount;
    }

    public void setOriginalPieceAmount(BigDecimal originalPieceAmount) {
        this.originalPieceAmount = originalPieceAmount;
    }

    public BigDecimal getAmount() {
        return this.amount == null ? BigDecimal.ZERO : this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public AnalyticJournal getAnalyticJournal() {
        return this.analyticJournal;
    }

    public void setAnalyticJournal(AnalyticJournal analyticJournal) {
        this.analyticJournal = analyticJournal;
    }

    public Account getAccount() {
        return this.account;
    }

    public void setAccount(Account account) {
        this.account = account;
    }

    public AccountType getAccountType() {
        return this.accountType;
    }

    public void setAccountType(AccountType accountType) {
        this.accountType = accountType;
    }

    public Integer getTypeSelect() {
        return this.typeSelect == null ? 0 : this.typeSelect;
    }

    public void setTypeSelect(Integer typeSelect) {
        this.typeSelect = typeSelect;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public void setCurrency(Currency currency) {
        this.currency = currency;
    }

    public ExpenseLine getExpenseLine() {
        return this.expenseLine;
    }

    public void setExpenseLine(ExpenseLine expenseLine) {
        this.expenseLine = expenseLine;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AnalyticMoveLine)) {
            return false;
        }
        AnalyticMoveLine other = (AnalyticMoveLine)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("percentage", (Object)this.getPercentage()).add("originalPieceAmount", (Object)this.getOriginalPieceAmount()).add("amount", (Object)this.getAmount()).add("date", (Object)this.getDate()).add("typeSelect", (Object)this.getTypeSelect()).omitNullValues().toString();
    }
}

