/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.talent.db.AppraisalType;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.TrackMessage;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_APPRAISAL", indexes={@Index(columnList="employee"), @Index(columnList="company"), @Index(columnList="appraisal_type"), @Index(columnList="reviewer_employee")})
@Track(fields={@TrackField(name="employee"), @TrackField(name="company"), @TrackField(name="appraisalType"), @TrackField(name="toDate"), @TrackField(name="reviewerEmployee"), @TrackField(name="attrs"), @TrackField(name="description"), @TrackField(name="statusSelect", on={TrackEvent.UPDATE}), @TrackField(name="isTemplate")}, messages={@TrackMessage(message="Appraisal sent", condition="statusSelect == 1", on={TrackEvent.UPDATE}), @TrackMessage(message="Appraisal realized", condition="statusSelect == 2", on={TrackEvent.UPDATE}), @TrackMessage(message="Appraisal cancelled", condition="statusSelect == 3", on={TrackEvent.UPDATE}), @TrackMessage(message="Appraisal draft", condition="statusSelect == 0", on={TrackEvent.UPDATE})})
public class Appraisal
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_APPRAISAL_SEQ")
    @SequenceGenerator(name="TALENT_APPRAISAL_SEQ", sequenceName="TALENT_APPRAISAL_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Employee")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Type of appraisal")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private AppraisalType appraisalType;
    @Widget(title="Deadline")
    private LocalDate toDate;
    @Widget(title="Reviewer")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee reviewerEmployee;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Status", readonly=true, selection="appraisal.status.selected")
    private Integer statusSelect = 0;
    @Widget(title="Is template")
    private Boolean isTemplate = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public AppraisalType getAppraisalType() {
        return this.appraisalType;
    }

    public void setAppraisalType(AppraisalType appraisalType) {
        this.appraisalType = appraisalType;
    }

    public LocalDate getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDate toDate) {
        this.toDate = toDate;
    }

    public Employee getReviewerEmployee() {
        return this.reviewerEmployee;
    }

    public void setReviewerEmployee(Employee reviewerEmployee) {
        this.reviewerEmployee = reviewerEmployee;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Boolean getIsTemplate() {
        return this.isTemplate == null ? Boolean.FALSE : this.isTemplate;
    }

    public void setIsTemplate(Boolean isTemplate) {
        this.isTemplate = isTemplate;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Appraisal)) {
            return false;
        }
        Appraisal other = (Appraisal)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("toDate", (Object)this.getToDate()).add("statusSelect", (Object)this.getStatusSelect()).add("isTemplate", (Object)this.getIsTemplate()).omitNullValues().toString();
    }
}

