/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.IndustrySector;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.talent.db.EducationLevel;
import com.axelor.apps.talent.db.HiringStage;
import com.axelor.apps.talent.db.JobPosition;
import com.axelor.apps.talent.db.Skill;
import com.axelor.apps.talent.db.TalentSource;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_JOB_APPLICATION", indexes={@Index(columnList="fullName"), @Index(columnList="email_address"), @Index(columnList="education_level"), @Index(columnList="talent_source"), @Index(columnList="job_position"), @Index(columnList="responsible"), @Index(columnList="employee"), @Index(columnList="hiring_stage"), @Index(columnList="picture"), @Index(columnList="employee_address")})
public class JobApplication
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_JOB_APPLICATION_SEQ")
    @SequenceGenerator(name="TALENT_JOB_APPLICATION_SEQ", sequenceName="TALENT_JOB_APPLICATION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Last name")
    private String lastName;
    @Widget(title="First name")
    private String firstName;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="Email")
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAddress emailAddress;
    @Widget(title="Fixed phone")
    private String fixedPhone;
    @Widget(title="Mobile phone")
    private String mobilePhone;
    @Widget(title="Level of education")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EducationLevel educationLevel;
    @Widget(title="Work experience", selection="job.position.experience.select")
    private Integer experienceSelect = 0;
    @Widget(title="Business sectors")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<IndustrySector> industrySectorSet;
    @Widget(title="LinkedIn profile")
    private String linkedInProfile;
    @Widget(title="Source")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TalentSource talentSource;
    @Widget(title="Referred by")
    private String referredBy;
    @Widget(title="Appreciation", selection="training.register.rating.select")
    private Integer appreciation = 0;
    @Widget(title="Applied job")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private JobPosition jobPosition;
    @Widget(title="Responsible")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee responsible;
    @Widget(title="Employee hired")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Expected salary")
    private String expectedSalary;
    @Widget(title="Proposed salary")
    private String proposedSalary;
    @Widget(title="Availability from")
    private LocalDate availabilityFrom;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Status", selection="job.application.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Hiring stage")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private HiringStage hiringStage;
    @Widget(title="Reason not hired")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String reasonNotHired;
    @Widget(title="Skills tag")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Skill> skillSet;
    @Widget(title="Photo")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private MetaFile picture;
    @Widget(title="Date of application")
    private LocalDate creationDate;
    @Widget(title="Title", selection="partner.title.type.select")
    private Integer titleSelect = 0;
    @Widget(title="Fax")
    private String fax;
    @Widget(title="Address")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Address employeeAddress;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public JobApplication() {
    }

    public JobApplication(MetaFile picture) {
        this.picture = picture;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public EmailAddress getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(EmailAddress emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getFixedPhone() {
        return this.fixedPhone;
    }

    public void setFixedPhone(String fixedPhone) {
        this.fixedPhone = fixedPhone;
    }

    public String getMobilePhone() {
        return this.mobilePhone;
    }

    public void setMobilePhone(String mobilePhone) {
        this.mobilePhone = mobilePhone;
    }

    public EducationLevel getEducationLevel() {
        return this.educationLevel;
    }

    public void setEducationLevel(EducationLevel educationLevel) {
        this.educationLevel = educationLevel;
    }

    public Integer getExperienceSelect() {
        return this.experienceSelect == null ? 0 : this.experienceSelect;
    }

    public void setExperienceSelect(Integer experienceSelect) {
        this.experienceSelect = experienceSelect;
    }

    public Set<IndustrySector> getIndustrySectorSet() {
        return this.industrySectorSet;
    }

    public void setIndustrySectorSet(Set<IndustrySector> industrySectorSet) {
        this.industrySectorSet = industrySectorSet;
    }

    public void addIndustrySectorSetItem(IndustrySector item) {
        if (this.getIndustrySectorSet() == null) {
            this.setIndustrySectorSet(new HashSet<IndustrySector>());
        }
        this.getIndustrySectorSet().add(item);
    }

    public void removeIndustrySectorSetItem(IndustrySector item) {
        if (this.getIndustrySectorSet() == null) {
            return;
        }
        this.getIndustrySectorSet().remove(item);
    }

    public void clearIndustrySectorSet() {
        if (this.getIndustrySectorSet() != null) {
            this.getIndustrySectorSet().clear();
        }
    }

    public String getLinkedInProfile() {
        return this.linkedInProfile;
    }

    public void setLinkedInProfile(String linkedInProfile) {
        this.linkedInProfile = linkedInProfile;
    }

    public TalentSource getTalentSource() {
        return this.talentSource;
    }

    public void setTalentSource(TalentSource talentSource) {
        this.talentSource = talentSource;
    }

    public String getReferredBy() {
        return this.referredBy;
    }

    public void setReferredBy(String referredBy) {
        this.referredBy = referredBy;
    }

    public Integer getAppreciation() {
        return this.appreciation == null ? 0 : this.appreciation;
    }

    public void setAppreciation(Integer appreciation) {
        this.appreciation = appreciation;
    }

    public JobPosition getJobPosition() {
        return this.jobPosition;
    }

    public void setJobPosition(JobPosition jobPosition) {
        this.jobPosition = jobPosition;
    }

    public Employee getResponsible() {
        return this.responsible;
    }

    public void setResponsible(Employee responsible) {
        this.responsible = responsible;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public String getExpectedSalary() {
        return this.expectedSalary;
    }

    public void setExpectedSalary(String expectedSalary) {
        this.expectedSalary = expectedSalary;
    }

    public String getProposedSalary() {
        return this.proposedSalary;
    }

    public void setProposedSalary(String proposedSalary) {
        this.proposedSalary = proposedSalary;
    }

    public LocalDate getAvailabilityFrom() {
        return this.availabilityFrom;
    }

    public void setAvailabilityFrom(LocalDate availabilityFrom) {
        this.availabilityFrom = availabilityFrom;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public HiringStage getHiringStage() {
        return this.hiringStage;
    }

    public void setHiringStage(HiringStage hiringStage) {
        this.hiringStage = hiringStage;
    }

    public String getReasonNotHired() {
        return this.reasonNotHired;
    }

    public void setReasonNotHired(String reasonNotHired) {
        this.reasonNotHired = reasonNotHired;
    }

    public Set<Skill> getSkillSet() {
        return this.skillSet;
    }

    public void setSkillSet(Set<Skill> skillSet) {
        this.skillSet = skillSet;
    }

    public void addSkillSetItem(Skill item) {
        if (this.getSkillSet() == null) {
            this.setSkillSet(new HashSet<Skill>());
        }
        this.getSkillSet().add(item);
    }

    public void removeSkillSetItem(Skill item) {
        if (this.getSkillSet() == null) {
            return;
        }
        this.getSkillSet().remove((Object)item);
    }

    public void clearSkillSet() {
        if (this.getSkillSet() != null) {
            this.getSkillSet().clear();
        }
    }

    public MetaFile getPicture() {
        return this.picture;
    }

    public void setPicture(MetaFile picture) {
        this.picture = picture;
    }

    public LocalDate getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(LocalDate creationDate) {
        this.creationDate = creationDate;
    }

    public Integer getTitleSelect() {
        return this.titleSelect == null ? 0 : this.titleSelect;
    }

    public void setTitleSelect(Integer titleSelect) {
        this.titleSelect = titleSelect;
    }

    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public Address getEmployeeAddress() {
        return this.employeeAddress;
    }

    public void setEmployeeAddress(Address employeeAddress) {
        this.employeeAddress = employeeAddress;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JobApplication)) {
            return false;
        }
        JobApplication other = (JobApplication)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("lastName", (Object)this.getLastName()).add("firstName", (Object)this.getFirstName()).add("fullName", (Object)this.getFullName()).add("fixedPhone", (Object)this.getFixedPhone()).add("mobilePhone", (Object)this.getMobilePhone()).add("experienceSelect", (Object)this.getExperienceSelect()).add("linkedInProfile", (Object)this.getLinkedInProfile()).add("referredBy", (Object)this.getReferredBy()).add("appreciation", (Object)this.getAppreciation()).add("expectedSalary", (Object)this.getExpectedSalary()).add("proposedSalary", (Object)this.getProposedSalary()).omitNullValues().toString();
    }
}

