/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.CompanyDepartment;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.EmploymentContractType;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.time.LocalDate;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_JOB_POSITION", indexes={@Index(columnList="jobTitle"), @Index(columnList="company_department"), @Index(columnList="employee"), @Index(columnList="contract_type"), @Index(columnList="mail_account"), @Index(columnList="company")})
public class JobPosition
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_JOB_POSITION_SEQ")
    @SequenceGenerator(name="TALENT_JOB_POSITION_SEQ", sequenceName="TALENT_JOB_POSITION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Job title")
    @NameColumn
    @NotNull
    private String jobTitle;
    @Widget(title="Job reference", readonly=true)
    private String jobReference;
    @Widget(title="Department")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CompanyDepartment companyDepartment;
    @Widget(title="Responsible")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Employee employee;
    @Widget(title="Contract type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmploymentContractType contractType;
    @Widget(title="Experience", selection="job.position.experience.select")
    private Integer experienceSelect = 0;
    @Widget(title="Salary")
    private String salary;
    @Widget(title="Location")
    private String location;
    @Widget(title="Job description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String jobDescription;
    @Widget(title="Job email")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private EmailAccount mailAccount;
    @Widget(title="Status", selection="job.position.status.select")
    private Integer statusSelect = 0;
    @Widget(title="Nb of open jobs")
    private Integer nbOpenJob = 0;
    @Widget(title="Nb of people hired", readonly=true)
    private Integer nbPeopleHired = 0;
    @Widget(title="Publication Date")
    private LocalDate publicationDate;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Position Status", selection="job.position.position.status")
    private String positionStatusSelect;
    @Widget(title="Starting date")
    private LocalDate startingDate;
    @Widget(title="Profile wanted")
    private String profileWanted;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public void setJobTitle(String jobTitle) {
        this.jobTitle = jobTitle;
    }

    public String getJobReference() {
        return this.jobReference;
    }

    public void setJobReference(String jobReference) {
        this.jobReference = jobReference;
    }

    public CompanyDepartment getCompanyDepartment() {
        return this.companyDepartment;
    }

    public void setCompanyDepartment(CompanyDepartment companyDepartment) {
        this.companyDepartment = companyDepartment;
    }

    public Employee getEmployee() {
        return this.employee;
    }

    public void setEmployee(Employee employee) {
        this.employee = employee;
    }

    public EmploymentContractType getContractType() {
        return this.contractType;
    }

    public void setContractType(EmploymentContractType contractType) {
        this.contractType = contractType;
    }

    public Integer getExperienceSelect() {
        return this.experienceSelect == null ? 0 : this.experienceSelect;
    }

    public void setExperienceSelect(Integer experienceSelect) {
        this.experienceSelect = experienceSelect;
    }

    public String getSalary() {
        return this.salary;
    }

    public void setSalary(String salary) {
        this.salary = salary;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getJobDescription() {
        return this.jobDescription;
    }

    public void setJobDescription(String jobDescription) {
        this.jobDescription = jobDescription;
    }

    public EmailAccount getMailAccount() {
        return this.mailAccount;
    }

    public void setMailAccount(EmailAccount mailAccount) {
        this.mailAccount = mailAccount;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Integer getNbOpenJob() {
        return this.nbOpenJob == null ? 0 : this.nbOpenJob;
    }

    public void setNbOpenJob(Integer nbOpenJob) {
        this.nbOpenJob = nbOpenJob;
    }

    public Integer getNbPeopleHired() {
        return this.nbPeopleHired == null ? 0 : this.nbPeopleHired;
    }

    public void setNbPeopleHired(Integer nbPeopleHired) {
        this.nbPeopleHired = nbPeopleHired;
    }

    public LocalDate getPublicationDate() {
        return this.publicationDate;
    }

    public void setPublicationDate(LocalDate publicationDate) {
        this.publicationDate = publicationDate;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public String getPositionStatusSelect() {
        return this.positionStatusSelect;
    }

    public void setPositionStatusSelect(String positionStatusSelect) {
        this.positionStatusSelect = positionStatusSelect;
    }

    public LocalDate getStartingDate() {
        return this.startingDate;
    }

    public void setStartingDate(LocalDate startingDate) {
        this.startingDate = startingDate;
    }

    public String getProfileWanted() {
        return this.profileWanted;
    }

    public void setProfileWanted(String profileWanted) {
        this.profileWanted = profileWanted;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JobPosition)) {
            return false;
        }
        JobPosition other = (JobPosition)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("jobTitle", (Object)this.getJobTitle()).add("jobReference", (Object)this.getJobReference()).add("experienceSelect", (Object)this.getExperienceSelect()).add("salary", (Object)this.getSalary()).add("location", (Object)this.getLocation()).add("statusSelect", (Object)this.getStatusSelect()).add("nbOpenJob", (Object)this.getNbOpenJob()).add("nbPeopleHired", (Object)this.getNbPeopleHired()).add("publicationDate", (Object)this.getPublicationDate()).add("positionStatusSelect", (Object)this.getPositionStatusSelect()).add("startingDate", (Object)this.getStartingDate()).omitNullValues().toString();
    }
}

