/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.talent.db.Skill;
import com.axelor.apps.talent.db.TrainingCategory;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_TRAINING", indexes={@Index(columnList="name"), @Index(columnList="category"), @Index(columnList="company")})
public class Training
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_TRAINING_SEQ")
    @SequenceGenerator(name="TALENT_TRAINING_SEQ", sequenceName="TALENT_TRAINING_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Name")
    @NotNull
    private String name;
    @Widget(title="Category")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private TrainingCategory category;
    @Widget(title="Company")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Company company;
    @Widget(title="Skill")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Skill> skillSet;
    @Widget(title="Required training")
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Set<Training> requiredTrainingSet;
    @Widget(title="Description")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String description;
    @Widget(title="Program")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String program;
    @Widget(title="Objectives")
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="text")
    private String objectives;
    @Widget(title="Number of hours")
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Mandatory training")
    private Boolean mandatoryTraining = Boolean.FALSE;
    @Widget(title="Rating")
    private BigDecimal rating = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Training() {
    }

    public Training(String name) {
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public TrainingCategory getCategory() {
        return this.category;
    }

    public void setCategory(TrainingCategory category) {
        this.category = category;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company company) {
        this.company = company;
    }

    public Set<Skill> getSkillSet() {
        return this.skillSet;
    }

    public void setSkillSet(Set<Skill> skillSet) {
        this.skillSet = skillSet;
    }

    public void addSkillSetItem(Skill item) {
        if (this.getSkillSet() == null) {
            this.setSkillSet(new HashSet<Skill>());
        }
        this.getSkillSet().add(item);
    }

    public void removeSkillSetItem(Skill item) {
        if (this.getSkillSet() == null) {
            return;
        }
        this.getSkillSet().remove((Object)item);
    }

    public void clearSkillSet() {
        if (this.getSkillSet() != null) {
            this.getSkillSet().clear();
        }
    }

    public Set<Training> getRequiredTrainingSet() {
        return this.requiredTrainingSet;
    }

    public void setRequiredTrainingSet(Set<Training> requiredTrainingSet) {
        this.requiredTrainingSet = requiredTrainingSet;
    }

    public void addRequiredTrainingSetItem(Training item) {
        if (this.getRequiredTrainingSet() == null) {
            this.setRequiredTrainingSet(new HashSet<Training>());
        }
        this.getRequiredTrainingSet().add(item);
    }

    public void removeRequiredTrainingSetItem(Training item) {
        if (this.getRequiredTrainingSet() == null) {
            return;
        }
        this.getRequiredTrainingSet().remove((Object)item);
    }

    public void clearRequiredTrainingSet() {
        if (this.getRequiredTrainingSet() != null) {
            this.getRequiredTrainingSet().clear();
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getProgram() {
        return this.program;
    }

    public void setProgram(String program) {
        this.program = program;
    }

    public String getObjectives() {
        return this.objectives;
    }

    public void setObjectives(String objectives) {
        this.objectives = objectives;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public Boolean getMandatoryTraining() {
        return this.mandatoryTraining == null ? Boolean.FALSE : this.mandatoryTraining;
    }

    public void setMandatoryTraining(Boolean mandatoryTraining) {
        this.mandatoryTraining = mandatoryTraining;
    }

    public BigDecimal getRating() {
        return this.rating == null ? BigDecimal.ZERO : this.rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Training)) {
            return false;
        }
        Training other = (Training)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("name", (Object)this.getName()).add("duration", (Object)this.getDuration()).add("mandatoryTraining", (Object)this.getMandatoryTraining()).add("rating", (Object)this.getRating()).omitNullValues().toString();
    }
}

