/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.db;

import com.axelor.apps.talent.db.Training;
import com.axelor.apps.talent.db.TrainingRegister;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.annotations.NameColumn;
import com.axelor.db.annotations.Widget;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.Basic;
import javax.persistence.Cacheable;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.hibernate.annotations.Type;

@Entity
@Cacheable
@Table(name="TALENT_TRAINING_SESSION", indexes={@Index(columnList="training"), @Index(columnList="fullName")})
public class TrainingSession
extends AuditableModel {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="TALENT_TRAINING_SESSION_SEQ")
    @SequenceGenerator(name="TALENT_TRAINING_SESSION_SEQ", sequenceName="TALENT_TRAINING_SESSION_SEQ", allocationSize=1)
    private Long id;
    @Widget(title="Status", selection="training.session.status.select")
    private Integer statusSelect = 1;
    @Widget(title="Training")
    @NotNull
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Training training;
    @Widget(title="From date")
    @NotNull
    private LocalDateTime fromDate;
    @Widget(title="To date")
    @NotNull
    private LocalDateTime toDate;
    @Widget(title="Number of registredred to the session")
    private Integer nbrRegistered = 0;
    @Widget(title="Number of hours")
    private BigDecimal duration = BigDecimal.ZERO;
    @Widget(title="Rating")
    private BigDecimal rating = BigDecimal.ZERO;
    @Widget(title="Full name")
    @NameColumn
    private String fullName;
    @Widget(title="Location")
    private String location;
    @Widget(title="Training register list")
    @OneToMany(fetch=FetchType.LAZY, mappedBy="trainingSession", cascade={CascadeType.ALL}, orphanRemoval=true)
    private List<TrainingRegister> trainingRegisterList;
    @Widget(title="Overall rating to apply")
    private BigDecimal overallRatingToApply = BigDecimal.ZERO;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getStatusSelect() {
        return this.statusSelect == null ? 0 : this.statusSelect;
    }

    public void setStatusSelect(Integer statusSelect) {
        this.statusSelect = statusSelect;
    }

    public Training getTraining() {
        return this.training;
    }

    public void setTraining(Training training) {
        this.training = training;
    }

    public LocalDateTime getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(LocalDateTime fromDate) {
        this.fromDate = fromDate;
    }

    public LocalDateTime getToDate() {
        return this.toDate;
    }

    public void setToDate(LocalDateTime toDate) {
        this.toDate = toDate;
    }

    public Integer getNbrRegistered() {
        return this.nbrRegistered == null ? 0 : this.nbrRegistered;
    }

    public void setNbrRegistered(Integer nbrRegistered) {
        this.nbrRegistered = nbrRegistered;
    }

    public BigDecimal getDuration() {
        return this.duration == null ? BigDecimal.ZERO : this.duration;
    }

    public void setDuration(BigDecimal duration) {
        this.duration = duration;
    }

    public BigDecimal getRating() {
        return this.rating == null ? BigDecimal.ZERO : this.rating;
    }

    public void setRating(BigDecimal rating) {
        this.rating = rating;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public List<TrainingRegister> getTrainingRegisterList() {
        return this.trainingRegisterList;
    }

    public void setTrainingRegisterList(List<TrainingRegister> trainingRegisterList) {
        this.trainingRegisterList = trainingRegisterList;
    }

    public void addTrainingRegisterListItem(TrainingRegister item) {
        if (this.getTrainingRegisterList() == null) {
            this.setTrainingRegisterList(new ArrayList<TrainingRegister>());
        }
        this.getTrainingRegisterList().add(item);
        item.setTrainingSession(this);
    }

    public void removeTrainingRegisterListItem(TrainingRegister item) {
        if (this.getTrainingRegisterList() == null) {
            return;
        }
        this.getTrainingRegisterList().remove((Object)item);
    }

    public void clearTrainingRegisterList() {
        if (this.getTrainingRegisterList() != null) {
            this.getTrainingRegisterList().clear();
        }
    }

    public BigDecimal getOverallRatingToApply() {
        return this.overallRatingToApply == null ? BigDecimal.ZERO : this.overallRatingToApply;
    }

    public void setOverallRatingToApply(BigDecimal overallRatingToApply) {
        this.overallRatingToApply = overallRatingToApply;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TrainingSession)) {
            return false;
        }
        TrainingSession other = (TrainingSession)((Object)obj);
        if (this.getId() != null || other.getId() != null) {
            return Objects.equals(this.getId(), other.getId());
        }
        return false;
    }

    public int hashCode() {
        return 31;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("statusSelect", (Object)this.getStatusSelect()).add("fromDate", (Object)this.getFromDate()).add("toDate", (Object)this.getToDate()).add("nbrRegistered", (Object)this.getNbrRegistered()).add("duration", (Object)this.getDuration()).add("rating", (Object)this.getRating()).add("fullName", (Object)this.getFullName()).add("location", (Object)this.getLocation()).add("overallRatingToApply", (Object)this.getOverallRatingToApply()).omitNullValues().toString();
    }
}

