/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.service;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.talent.db.JobApplication;
import com.axelor.apps.talent.db.Skill;
import com.axelor.apps.talent.db.repo.JobApplicationRepository;
import com.axelor.apps.talent.service.JobApplicationService;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;

public class JobApplicationServiceImpl
implements JobApplicationService {
    @Inject
    protected JobApplicationRepository jobApplicationRepo;
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected PartnerService partnerService;
    @Inject
    private MetaFiles metaFiles;

    @Override
    @Transactional
    public Employee hire(JobApplication jobApplication) {
        Employee employee = this.createEmployee(jobApplication);
        jobApplication.setStatusSelect(JobApplicationRepository.STATUS_HIRED);
        jobApplication.setEmployee(employee);
        if (jobApplication.getJobPosition() != null) {
            int nbPeopleHired = jobApplication.getJobPosition().getNbPeopleHired();
            jobApplication.getJobPosition().setNbPeopleHired(++nbPeopleHired);
        }
        this.jobApplicationRepo.save((Model)((Object)jobApplication));
        return employee;
    }

    protected Employee createEmployee(JobApplication jobApplication) {
        Employee employee = new Employee();
        employee.setHireDate(this.appBaseService.getTodayDate(jobApplication.getJobPosition().getCompany()));
        employee.setContactPartner(this.createContact(jobApplication));
        HashSet<Skill> tagSkillSet = new HashSet<Skill>();
        tagSkillSet.addAll(jobApplication.getSkillSet());
        employee.setSkillSet(tagSkillSet);
        if (employee.getMainEmploymentContract() != null) {
            employee.getMainEmploymentContract().setCompanyDepartment(jobApplication.getJobPosition().getCompanyDepartment());
        }
        employee.setName(employee.getContactPartner().getName());
        return employee;
    }

    protected Partner createContact(JobApplication jobApplication) {
        Partner contact = new Partner();
        contact.setPartnerTypeSelect(2);
        contact.setFirstName(jobApplication.getFirstName());
        contact.setName(jobApplication.getLastName());
        contact.setIsContact(true);
        contact.setIsEmployee(true);
        contact.setFixedPhone(jobApplication.getFixedPhone());
        contact.setMobilePhone(jobApplication.getMobilePhone());
        contact.setEmailAddress(jobApplication.getEmailAddress());
        if (jobApplication.getPicture() != null) {
            File file = MetaFiles.getPath((MetaFile)jobApplication.getPicture()).toFile();
            try {
                contact.setPicture(this.metaFiles.upload(file));
            }
            catch (IOException e) {
                TraceBackService.trace((Throwable)e);
            }
        }
        this.partnerService.setPartnerFullName(contact);
        return contact;
    }

    @Override
    public String computeFullName(JobApplication jobApplication) {
        String fullName = null;
        if (jobApplication.getFirstName() != null) {
            fullName = jobApplication.getFirstName();
        }
        fullName = fullName == null ? jobApplication.getLastName() : fullName + " " + jobApplication.getLastName();
        return fullName;
    }
}

