/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.web;

import com.axelor.apps.hr.db.Employee;
import com.axelor.apps.hr.db.repo.EmployeeRepository;
import com.axelor.apps.talent.db.Appraisal;
import com.axelor.apps.talent.db.repo.AppraisalRepository;
import com.axelor.apps.talent.service.AppraisalService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@Singleton
public class AppraisalController {
    public void send(ActionRequest request, ActionResponse response) {
        Appraisal appraisal = (Appraisal)((Object)request.getContext().asType(Appraisal.class));
        try {
            appraisal = (Appraisal)((Object)((AppraisalRepository)((Object)Beans.get(AppraisalRepository.class))).find(appraisal.getId()));
            ((AppraisalService)Beans.get(AppraisalService.class)).send(appraisal);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void realize(ActionRequest request, ActionResponse response) {
        Appraisal appraisal = (Appraisal)((Object)request.getContext().asType(Appraisal.class));
        try {
            appraisal = (Appraisal)((Object)((AppraisalRepository)((Object)Beans.get(AppraisalRepository.class))).find(appraisal.getId()));
            ((AppraisalService)Beans.get(AppraisalService.class)).realize(appraisal);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        Appraisal appraisal = (Appraisal)((Object)request.getContext().asType(Appraisal.class));
        try {
            appraisal = (Appraisal)((Object)((AppraisalRepository)((Object)Beans.get(AppraisalRepository.class))).find(appraisal.getId()));
            ((AppraisalService)Beans.get(AppraisalService.class)).cancel(appraisal);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void draft(ActionRequest request, ActionResponse response) {
        Appraisal appraisal = (Appraisal)((Object)request.getContext().asType(Appraisal.class));
        try {
            appraisal = (Appraisal)((Object)((AppraisalRepository)((Object)Beans.get(AppraisalRepository.class))).find(appraisal.getId()));
            ((AppraisalService)Beans.get(AppraisalService.class)).draft(appraisal);
            response.setReload(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void createAppraisals(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            HashSet employeeSet = new HashSet();
            employeeSet.addAll((Collection)context.get((Object)"employeeSet"));
            HashSet<Employee> employees = new HashSet<Employee>();
            EmployeeRepository employeeRepo = (EmployeeRepository)((Object)Beans.get(EmployeeRepository.class));
            for (Map emp : employeeSet) {
                Long empId = Long.parseLong(emp.get("id").toString());
                employees.add((Employee)((Object)employeeRepo.find(empId)));
            }
            Long templateId = Long.parseLong(context.get((Object)"templateId").toString());
            Appraisal appraisalTemplate = (Appraisal)((Object)((AppraisalRepository)((Object)Beans.get(AppraisalRepository.class))).find(templateId));
            Boolean send = (Boolean)context.get((Object)"sendAppraisals");
            Set<Long> createdIds = ((AppraisalService)Beans.get(AppraisalService.class)).createAppraisals(appraisalTemplate, employees, send);
            response.setView(ActionView.define((String)"Appraisal").model(Appraisal.class.getName()).add("grid", "appraisal-grid").add("form", "appraisal-form").param("search-filters", "appraisal-fitlers").domain("self.id in :createdIds").context("createdIds", createdIds).map());
            response.setCanClose(true);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

