/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.talent.web;

import com.axelor.apps.crm.db.Event;
import com.axelor.apps.crm.db.repo.EventRepository;
import com.axelor.apps.talent.db.Training;
import com.axelor.apps.talent.db.TrainingRegister;
import com.axelor.apps.talent.db.TrainingSession;
import com.axelor.apps.talent.db.repo.TrainingRegisterRepository;
import com.axelor.apps.talent.db.repo.TrainingSessionRepository;
import com.axelor.apps.talent.service.TrainingRegisterService;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.util.ArrayList;

@Singleton
public class TrainingRegisterController {
    @Inject
    private EventRepository eventRepository;

    public void updateEventCalendar(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        ((TrainingRegisterService)Beans.get(TrainingRegisterService.class)).updateEventCalendar(trainingRegister);
    }

    public void complete(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        trainingRegister = (TrainingRegister)((Object)((TrainingRegisterRepository)((Object)Beans.get(TrainingRegisterRepository.class))).find(trainingRegister.getId()));
        ((TrainingRegisterService)Beans.get(TrainingRegisterService.class)).complete(trainingRegister);
        response.setReload(true);
    }

    public void cancel(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        trainingRegister = (TrainingRegister)((Object)((TrainingRegisterRepository)((Object)Beans.get(TrainingRegisterRepository.class))).find(trainingRegister.getId()));
        ((TrainingRegisterService)Beans.get(TrainingRegisterService.class)).cancel(trainingRegister);
        response.setReload(true);
    }

    public void updateOldRating(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        TrainingRegisterService trainingRegisterService = (TrainingRegisterService)Beans.get(TrainingRegisterService.class);
        Training trainingSaved = null;
        TrainingSession trainingSessionSaved = null;
        if (trainingRegister.getId() != null) {
            TrainingRegister trainingRegisterSaved = (TrainingRegister)((Object)((TrainingRegisterRepository)((Object)Beans.get(TrainingRegisterRepository.class))).find(trainingRegister.getId()));
            trainingSessionSaved = trainingRegisterSaved.getTrainingSession();
            trainingSaved = trainingRegisterSaved.getTraining();
        }
        if (trainingSaved != null && trainingSaved.getId().equals(trainingRegister.getTraining().getId())) {
            trainingRegisterService.updateTrainingRating(trainingSaved, trainingRegister.getId());
        }
        if (trainingSessionSaved != null && (trainingRegister.getTrainingSession() == null || trainingRegister.getTrainingSession().getId().equals(trainingSessionSaved.getId()))) {
            trainingRegisterService.updateSessionRating(trainingSessionSaved, trainingRegister.getId());
        }
    }

    @Transactional
    public void EventUserUpdate(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        if (trainingRegister.getEventList() != null) {
            for (Event event : trainingRegister.getEventList()) {
                event.setUser(trainingRegister.getEmployee().getUser());
                this.eventRepository.save((Model)event);
            }
        }
    }

    @Transactional
    public void EventFromDateUpdate(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        if (trainingRegister.getEventList() != null) {
            for (Event event : trainingRegister.getEventList()) {
                event.setStartDateTime(trainingRegister.getFromDate());
                this.eventRepository.save((Model)event);
            }
        }
    }

    @Transactional
    public void EventToDateUpdate(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        if (trainingRegister.getEventList() != null) {
            for (Event event : trainingRegister.getEventList()) {
                event.setEndDateTime(trainingRegister.getToDate());
                this.eventRepository.save((Model)event);
            }
        }
    }

    @Transactional
    public void EventCalenderUpdate(ActionRequest request, ActionResponse response) {
        TrainingRegister trainingRegister = (TrainingRegister)((Object)request.getContext().asType(TrainingRegister.class));
        if (trainingRegister.getEventList() != null) {
            for (Event event : trainingRegister.getEventList()) {
                event.setCalendar(trainingRegister.getCalendar());
                this.eventRepository.save((Model)event);
            }
        }
    }

    public void massTrainingRegisterCreation(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        ArrayList employeeList = (ArrayList)context.get((Object)"employeeList");
        TrainingSession trainingSession = (TrainingSession)((Object)((TrainingSessionRepository)((Object)Beans.get(TrainingSessionRepository.class))).find(Long.parseLong(context.get((Object)"_trainingSessionId").toString())));
        String eventList = ((TrainingRegisterService)Beans.get(TrainingRegisterService.class)).massTrainingRegisterCreation(employeeList, trainingSession);
        response.setCanClose(true);
        if (!eventList.equals("()")) {
            response.setView(ActionView.define((String)"Meeting").model(Event.class.getCanonicalName()).add("grid", "event-grid").add("form", "event-form").param("search-filters", "event-filters").domain("self.id in " + eventList).map());
        } else {
            response.setAlert("No Training register is generated because selected employees don't have any user.");
        }
    }
}

