/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.db;

import com.axelor.apps.base.db.App;
import com.axelor.apps.base.db.BarcodeTypeConfig;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.production.db.CostSheetGroup;
import com.axelor.db.EntityHelper;
import com.axelor.db.Model;
import com.axelor.db.annotations.Track;
import com.axelor.db.annotations.TrackEvent;
import com.axelor.db.annotations.TrackField;
import com.axelor.db.annotations.Widget;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Index;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.validation.constraints.Max;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BASE_APP_PRODUCTION", indexes={@Index(columnList="work_center_product"), @Index(columnList="work_center_cost_sheet_group"), @Index(columnList="product_cost_sheet_group"), @Index(columnList="cycle_unit"), @Index(columnList="barcode_type_config")})
@Track(fields={@TrackField(name="prodOrderMgtOnSO", on={TrackEvent.UPDATE}), @TrackField(name="productionOrderGenerationAuto", on={TrackEvent.UPDATE}), @TrackField(name="oneProdOrderPerSO", on={TrackEvent.UPDATE}), @TrackField(name="autoPlanManufOrderFromSO", on={TrackEvent.UPDATE}), @TrackField(name="workCenterProduct", on={TrackEvent.UPDATE}), @TrackField(name="workCenterCostSheetGroup", on={TrackEvent.UPDATE}), @TrackField(name="productCostSheetGroup", on={TrackEvent.UPDATE}), @TrackField(name="cycleUnit", on={TrackEvent.UPDATE}), @TrackField(name="manageResidualProductOnBom", on={TrackEvent.UPDATE}), @TrackField(name="subtractProdResidualOnCostSheet", on={TrackEvent.UPDATE}), @TrackField(name="manageBillOfMaterialVersion", on={TrackEvent.UPDATE}), @TrackField(name="manageProdProcessVersion", on={TrackEvent.UPDATE}), @TrackField(name="enableConfigurator", on={TrackEvent.UPDATE}), @TrackField(name="manageWorkshop", on={TrackEvent.UPDATE}), @TrackField(name="nbDecimalDigitForBomQty", on={TrackEvent.UPDATE}), @TrackField(name="barcodeTypeConfig", on={TrackEvent.UPDATE}), @TrackField(name="printPlannedDateOnManufOrder", on={TrackEvent.UPDATE}), @TrackField(name="manageBusinessProduction", on={TrackEvent.UPDATE}), @TrackField(name="enableTimesheetOnManufOrder", on={TrackEvent.UPDATE})})
public class AppProduction
extends App {
    @Widget(title="Production order management from sale order")
    private Boolean prodOrderMgtOnSO = Boolean.FALSE;
    @Widget(title="Generate production orders automatically")
    private Boolean productionOrderGenerationAuto = Boolean.FALSE;
    @Widget(title="One production order per sale order")
    private Boolean oneProdOrderPerSO = Boolean.TRUE;
    @Widget(title="Automatically plan the manuf. orders generated from sale order")
    private Boolean autoPlanManufOrderFromSO = Boolean.FALSE;
    @Widget(title="Default work center product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Product workCenterProduct;
    @Widget(title="Cost sheet group for work center")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheetGroup workCenterCostSheetGroup;
    @Widget(title="Cost sheet group for product")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private CostSheetGroup productCostSheetGroup;
    @Widget(title="Cycle unit")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private Unit cycleUnit;
    @Widget(title="Manage residual products on BOM")
    private Boolean manageResidualProductOnBom = Boolean.FALSE;
    @Widget(title="Subtract the product residuals cost on Cost sheet")
    private Boolean subtractProdResidualOnCostSheet = Boolean.FALSE;
    @Widget(title="Manage bill of materials versions")
    private Boolean manageBillOfMaterialVersion = Boolean.FALSE;
    @Widget(title="Manage production process versions")
    private Boolean manageProdProcessVersion = Boolean.FALSE;
    @Widget(title="Manage cost sheet group")
    private Boolean manageCostSheetGroup = Boolean.FALSE;
    @Widget(title="Enable production configurator")
    private Boolean enableConfigurator = Boolean.FALSE;
    @Widget(title="Manage workshop")
    private Boolean manageWorkshop = Boolean.FALSE;
    @Widget(title="Nb of digits for BOM quantities")
    @Max(value=10L)
    private Integer nbDecimalDigitForBomQty = 2;
    @Widget(title="Barcode Type")
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    private BarcodeTypeConfig barcodeTypeConfig;
    @Widget(title="Print planned date on manuf order ?")
    private Boolean printPlannedDateOnManufOrder = Boolean.TRUE;
    @Widget(title="Status considered to filter a manuf order", selection="production.manuf.order.status.select")
    private String mOFilterOnStockDetailStatusSelect = "4,5";
    @Widget(title="Manage business production")
    private Boolean manageBusinessProduction = Boolean.FALSE;
    @Widget(title="Enable timesheet on manuf order")
    private Boolean enableTimesheetOnManufOrder = Boolean.FALSE;
    @Widget(title="Attributes")
    @Basic(fetch=FetchType.LAZY)
    @Type(type="json")
    private String attrs;

    public Boolean getProdOrderMgtOnSO() {
        return this.prodOrderMgtOnSO == null ? Boolean.FALSE : this.prodOrderMgtOnSO;
    }

    public void setProdOrderMgtOnSO(Boolean prodOrderMgtOnSO) {
        this.prodOrderMgtOnSO = prodOrderMgtOnSO;
    }

    public Boolean getProductionOrderGenerationAuto() {
        return this.productionOrderGenerationAuto == null ? Boolean.FALSE : this.productionOrderGenerationAuto;
    }

    public void setProductionOrderGenerationAuto(Boolean productionOrderGenerationAuto) {
        this.productionOrderGenerationAuto = productionOrderGenerationAuto;
    }

    public Boolean getOneProdOrderPerSO() {
        return this.oneProdOrderPerSO == null ? Boolean.FALSE : this.oneProdOrderPerSO;
    }

    public void setOneProdOrderPerSO(Boolean oneProdOrderPerSO) {
        this.oneProdOrderPerSO = oneProdOrderPerSO;
    }

    public Boolean getAutoPlanManufOrderFromSO() {
        return this.autoPlanManufOrderFromSO == null ? Boolean.FALSE : this.autoPlanManufOrderFromSO;
    }

    public void setAutoPlanManufOrderFromSO(Boolean autoPlanManufOrderFromSO) {
        this.autoPlanManufOrderFromSO = autoPlanManufOrderFromSO;
    }

    public Product getWorkCenterProduct() {
        return this.workCenterProduct;
    }

    public void setWorkCenterProduct(Product workCenterProduct) {
        this.workCenterProduct = workCenterProduct;
    }

    public CostSheetGroup getWorkCenterCostSheetGroup() {
        return this.workCenterCostSheetGroup;
    }

    public void setWorkCenterCostSheetGroup(CostSheetGroup workCenterCostSheetGroup) {
        this.workCenterCostSheetGroup = workCenterCostSheetGroup;
    }

    public CostSheetGroup getProductCostSheetGroup() {
        return this.productCostSheetGroup;
    }

    public void setProductCostSheetGroup(CostSheetGroup productCostSheetGroup) {
        this.productCostSheetGroup = productCostSheetGroup;
    }

    public Unit getCycleUnit() {
        return this.cycleUnit;
    }

    public void setCycleUnit(Unit cycleUnit) {
        this.cycleUnit = cycleUnit;
    }

    public Boolean getManageResidualProductOnBom() {
        return this.manageResidualProductOnBom == null ? Boolean.FALSE : this.manageResidualProductOnBom;
    }

    public void setManageResidualProductOnBom(Boolean manageResidualProductOnBom) {
        this.manageResidualProductOnBom = manageResidualProductOnBom;
    }

    public Boolean getSubtractProdResidualOnCostSheet() {
        return this.subtractProdResidualOnCostSheet == null ? Boolean.FALSE : this.subtractProdResidualOnCostSheet;
    }

    public void setSubtractProdResidualOnCostSheet(Boolean subtractProdResidualOnCostSheet) {
        this.subtractProdResidualOnCostSheet = subtractProdResidualOnCostSheet;
    }

    public Boolean getManageBillOfMaterialVersion() {
        return this.manageBillOfMaterialVersion == null ? Boolean.FALSE : this.manageBillOfMaterialVersion;
    }

    public void setManageBillOfMaterialVersion(Boolean manageBillOfMaterialVersion) {
        this.manageBillOfMaterialVersion = manageBillOfMaterialVersion;
    }

    public Boolean getManageProdProcessVersion() {
        return this.manageProdProcessVersion == null ? Boolean.FALSE : this.manageProdProcessVersion;
    }

    public void setManageProdProcessVersion(Boolean manageProdProcessVersion) {
        this.manageProdProcessVersion = manageProdProcessVersion;
    }

    public Boolean getManageCostSheetGroup() {
        return this.manageCostSheetGroup == null ? Boolean.FALSE : this.manageCostSheetGroup;
    }

    public void setManageCostSheetGroup(Boolean manageCostSheetGroup) {
        this.manageCostSheetGroup = manageCostSheetGroup;
    }

    public Boolean getEnableConfigurator() {
        return this.enableConfigurator == null ? Boolean.FALSE : this.enableConfigurator;
    }

    public void setEnableConfigurator(Boolean enableConfigurator) {
        this.enableConfigurator = enableConfigurator;
    }

    public Boolean getManageWorkshop() {
        return this.manageWorkshop == null ? Boolean.FALSE : this.manageWorkshop;
    }

    public void setManageWorkshop(Boolean manageWorkshop) {
        this.manageWorkshop = manageWorkshop;
    }

    public Integer getNbDecimalDigitForBomQty() {
        return this.nbDecimalDigitForBomQty == null ? 0 : this.nbDecimalDigitForBomQty;
    }

    public void setNbDecimalDigitForBomQty(Integer nbDecimalDigitForBomQty) {
        this.nbDecimalDigitForBomQty = nbDecimalDigitForBomQty;
    }

    public BarcodeTypeConfig getBarcodeTypeConfig() {
        return this.barcodeTypeConfig;
    }

    public void setBarcodeTypeConfig(BarcodeTypeConfig barcodeTypeConfig) {
        this.barcodeTypeConfig = barcodeTypeConfig;
    }

    public Boolean getPrintPlannedDateOnManufOrder() {
        return this.printPlannedDateOnManufOrder == null ? Boolean.FALSE : this.printPlannedDateOnManufOrder;
    }

    public void setPrintPlannedDateOnManufOrder(Boolean printPlannedDateOnManufOrder) {
        this.printPlannedDateOnManufOrder = printPlannedDateOnManufOrder;
    }

    public String getmOFilterOnStockDetailStatusSelect() {
        return this.mOFilterOnStockDetailStatusSelect;
    }

    public void setmOFilterOnStockDetailStatusSelect(String mOFilterOnStockDetailStatusSelect) {
        this.mOFilterOnStockDetailStatusSelect = mOFilterOnStockDetailStatusSelect;
    }

    public Boolean getManageBusinessProduction() {
        return this.manageBusinessProduction == null ? Boolean.FALSE : this.manageBusinessProduction;
    }

    public void setManageBusinessProduction(Boolean manageBusinessProduction) {
        this.manageBusinessProduction = manageBusinessProduction;
    }

    public Boolean getEnableTimesheetOnManufOrder() {
        return this.enableTimesheetOnManufOrder == null ? Boolean.FALSE : this.enableTimesheetOnManufOrder;
    }

    public void setEnableTimesheetOnManufOrder(Boolean enableTimesheetOnManufOrder) {
        this.enableTimesheetOnManufOrder = enableTimesheetOnManufOrder;
    }

    public String getAttrs() {
        return this.attrs;
    }

    public void setAttrs(String attrs) {
        this.attrs = attrs;
    }

    public boolean equals(Object obj) {
        return EntityHelper.equals((Model)((Object)this), (Object)obj);
    }

    public int hashCode() {
        return EntityHelper.hashCode((Model)((Object)this));
    }

    public String toString() {
        return EntityHelper.toString((Model)((Object)this));
    }
}

